/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.item;

import com.moderocky.item.ItemStacker;
import com.moderocky.item.NBTWrapper;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.server.v1_15_R1.ItemStack;
import net.minecraft.server.v1_15_R1.MojangsonParser;
import net.minecraft.server.v1_15_R1.NBTBase;
import net.minecraft.server.v1_15_R1.NBTTagCompound;
import org.bukkit.Color;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftItemStack;

public class NBTWrapperItem {
    private ItemStack nmsItemStack;
    private org.bukkit.inventory.ItemStack bukkitStack;

    public NBTWrapperItem(String nmsItemString) {
        this.nmsItemStack = NBTWrapper.createItemStack(NBTWrapper.parse(nmsItemString));
    }

    public NBTWrapperItem(org.bukkit.inventory.ItemStack bukkitStack) {
        this.nmsItemStack = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)bukkitStack);
        this.bukkitStack = bukkitStack;
    }

    public NBTWrapperItem(ItemStack nmsItemStack) {
        this.nmsItemStack = nmsItemStack;
    }

    public NBTWrapperItem(CraftItemStack craftItemStack) {
        this.nmsItemStack = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)craftItemStack);
    }

    public ItemStack getNMSItemStack() {
        return this.nmsItemStack;
    }

    public CraftItemStack getCraftItemStack() {
        return CraftItemStack.asCraftCopy((org.bukkit.inventory.ItemStack)this.getBukkitItemStack());
    }

    public org.bukkit.inventory.ItemStack getBukkitItemStack() {
        return CraftItemStack.asBukkitCopy((ItemStack)this.nmsItemStack);
    }

    public String toString() {
        return this.nmsItemStack.save(new NBTTagCompound()).toString();
    }

    public NBTWrapperItem addNBT(String tag, String value) {
        NBTTagCompound nbt = this.nmsItemStack.getTag();
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        this.nmsItemStack.setTag(nbt.a(NBTWrapper.parse(value)));
        return this;
    }

    public NBTWrapperItem setValue(String tag, String value) {
        this.set(tag, value);
        return this;
    }

    public NBTWrapperItem setValue(String tag, Object value) {
        NBTTagCompound compound = this.getNBT();
        if (value instanceof String) {
            this.set(tag, (String)value);
        } else if (value instanceof Integer) {
            this.set(tag, (Integer)value);
        } else if (value instanceof Integer[]) {
            this.set(tag, (int[])value);
        } else if (value instanceof Double) {
            this.set(tag, (Double)value);
        } else if (value instanceof Float) {
            this.set(tag, ((Float)value).floatValue());
        } else if (value instanceof Byte) {
            this.set(tag, (Byte)value);
        } else if (value instanceof Byte[]) {
            this.set(tag, (byte[])value);
        } else if (value instanceof Short) {
            this.set(tag, (Short)value);
        } else if (value instanceof Long) {
            this.set(tag, (Long)value);
        } else {
            this.set(tag, value.toString());
        }
        this.nmsItemStack.setTag(compound);
        return this;
    }

    public NBTWrapperItem set(String tag, String value) {
        NBTTagCompound compound = this.getNBT();
        compound.setString(tag, value);
        this.nmsItemStack.setTag(compound);
        return this;
    }

    public NBTWrapperItem set(String tag, boolean value) {
        NBTTagCompound compound = this.getNBT();
        compound.setBoolean(tag, value);
        this.nmsItemStack.setTag(compound);
        return this;
    }

    public NBTWrapperItem set(String tag, byte value) {
        NBTTagCompound compound = this.getNBT();
        compound.setByte(tag, value);
        this.nmsItemStack.setTag(compound);
        return this;
    }

    public NBTWrapperItem set(String tag, byte[] value) {
        NBTTagCompound compound = this.getNBT();
        compound.setByteArray(tag, value);
        this.nmsItemStack.setTag(compound);
        return this;
    }

    public NBTWrapperItem set(String tag, int value) {
        NBTTagCompound compound = this.getNBT();
        compound.setInt(tag, value);
        this.nmsItemStack.setTag(compound);
        return this;
    }

    public NBTWrapperItem set(String tag, int[] value) {
        NBTTagCompound compound = this.getNBT();
        compound.setIntArray(tag, value);
        this.nmsItemStack.setTag(compound);
        return this;
    }

    public NBTWrapperItem set(String tag, float value) {
        NBTTagCompound compound = this.getNBT();
        compound.setFloat(tag, value);
        this.nmsItemStack.setTag(compound);
        return this;
    }

    public NBTWrapperItem set(String tag, double value) {
        NBTTagCompound compound = this.getNBT();
        compound.setDouble(tag, value);
        this.nmsItemStack.setTag(compound);
        return this;
    }

    public NBTWrapperItem set(String tag, long value) {
        NBTTagCompound compound = this.getNBT();
        compound.setLong(tag, value);
        this.nmsItemStack.setTag(compound);
        return this;
    }

    public NBTWrapperItem set(String tag, short value) {
        NBTTagCompound compound = this.getNBT();
        compound.setShort(tag, value);
        this.nmsItemStack.setTag(compound);
        return this;
    }

    public NBTWrapperItem set(String tag, NBTBase value) {
        NBTTagCompound compound = this.getNBT();
        compound.set(tag, value);
        this.nmsItemStack.setTag(compound);
        return this;
    }

    public NBTTagCompound getNBT() {
        return this.nmsItemStack.save(new NBTTagCompound());
    }

    public NBTWrapperItem setNBT(String value) {
        this.nmsItemStack.setTag(NBTWrapper.parse(value));
        return this;
    }

    public NBTWrapperItem clear(String tag) {
        NBTTagCompound compound = this.getNBT();
        compound.remove(tag);
        this.nmsItemStack.setTag(compound);
        return this;
    }

    public boolean hasKey(String tag) {
        return this.getNBT().hasKey(tag);
    }

    public String getValue(String tag) {
        NBTTagCompound nbt = this.nmsItemStack.getTag();
        if (nbt == null) {
            return null;
        }
        NBTBase base = nbt.get(tag);
        if (base == null) {
            return null;
        }
        return base.toString();
    }

    public String getString(String tag) {
        NBTTagCompound nbt = this.nmsItemStack.getTag();
        if (nbt == null) {
            return "";
        }
        NBTBase base = nbt.get(tag);
        if (base == null) {
            return "";
        }
        return base.toString().substring(1, base.toString().length() - 1);
    }

    public Integer getInt(String tag) {
        NBTTagCompound nbt = this.nmsItemStack.getTag();
        if (nbt == null) {
            return 0;
        }
        NBTBase base = nbt.get(tag);
        if (base == null) {
            return 0;
        }
        return Integer.valueOf(base.toString());
    }

    public Double getDouble(String tag) {
        NBTTagCompound nbt = this.nmsItemStack.getTag();
        if (nbt == null) {
            return 0.0;
        }
        NBTBase base = nbt.get(tag);
        if (base == null) {
            return 0.0;
        }
        return Double.valueOf(base.toString().replace("f", "").replace("d", ""));
    }

    public Color getColour(String tag) {
        NBTTagCompound nbt = this.nmsItemStack.getTag();
        if (nbt == null) {
            return Color.fromRGB((int)0, (int)0, (int)0);
        }
        NBTBase base = nbt.get(tag);
        if (base == null) {
            return Color.fromRGB((int)0, (int)0, (int)0);
        }
        return Color.fromRGB((int)Integer.valueOf(base.toString()));
    }

    public Boolean getBoolean(String tag) {
        NBTTagCompound nbt = this.nmsItemStack.getTag();
        if (nbt == null) {
            return false;
        }
        NBTBase base = nbt.get(tag);
        if (base == null || base.toString() == null) {
            return null;
        }
        return base.toString().contains("1");
    }

    public NBTWrapperItem addNBT(String string) {
        NBTTagCompound nbt = new NBTTagCompound();
        if (this.nmsItemStack.getTag() != null) {
            nbt = this.nmsItemStack.getTag();
        }
        try {
            NBTTagCompound nbtv = MojangsonParser.parse((String)string);
            nbt.a(nbtv);
            this.nmsItemStack.setTag(nbt);
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return this;
    }

    public ItemStacker getStacker() {
        return new ItemStacker(this.getBukkitItemStack());
    }

    public org.bukkit.inventory.ItemStack clone(org.bukkit.inventory.ItemStack itemStack) {
        itemStack.setItemMeta(this.getBukkitItemStack().getItemMeta());
        return itemStack;
    }
}

