/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.item;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.server.v1_15_R1.ItemStack;
import net.minecraft.server.v1_15_R1.MojangsonParser;
import net.minecraft.server.v1_15_R1.NBTBase;
import net.minecraft.server.v1_15_R1.NBTTagCompound;

public class NBTWrapper {
    static NBTTagCompound parse(String string) {
        if (string != null) {
            try {
                return MojangsonParser.parse((String)string);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
        return new NBTTagCompound();
    }

    static NBTTagCompound joinTags(NBTTagCompound base, NBTTagCompound[] additives) {
        for (NBTTagCompound additive : additives) {
            base.a(additive);
        }
        return base;
    }

    static String getValue(NBTTagCompound base, String tag) {
        NBTBase ret = base.get(tag);
        if (ret == null) {
            return new NBTTagCompound().toString();
        }
        return ret.toString();
    }

    static Map<String, NBTBase> getMap(NBTTagCompound base) {
        try {
            Field field = base.getClass().getDeclaredField("map");
            field.setAccessible(true);
            return (Map)field.get(base);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return new HashMap<String, NBTBase>();
        }
    }

    static String getTag(String a, String b) {
        NBTTagCompound nbt = NBTWrapper.parse(b);
        NBTBase base = nbt.get(a);
        if (base != null) {
            return base.toString();
        }
        return null;
    }

    static List<String> getAllTags(NBTTagCompound base) {
        return new ArrayList<String>(NBTWrapper.getMap(base).keySet());
    }

    static List<String> getAllValues(NBTTagCompound base) {
        ArrayList<String> list = new ArrayList<String>();
        Map<String, NBTBase> map = NBTWrapper.getMap(base);
        for (NBTBase obj : map.values()) {
            list.add(obj.asString());
        }
        return list;
    }

    static ItemStack createItemStack(NBTTagCompound nbtTagCompound) {
        return ItemStack.a((NBTTagCompound)nbtTagCompound);
    }
}

