/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.transk.effect;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.TranslatableComponent;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="Complex Translated Message")
@Description(value={"Sends a complex translated message to players.\n  - This message can be a default one from the Minecraft lang file.\n  - It can also be a custom one included via mod or resource pack.\n  - Inside the language files, you can use \u00a7 to colour messages.\n  - Complex messages can include placeholder values using '%s' in the lang file.\n  - These %s's are filled in with your inputs. To use normal percents, double the %%.\n  - You are also able to specify the order using '%1$s' and '%2$s'."})
@Examples(value={"send complex translated \"translation.test.args\" with inputs \"hello\" and \"there\" to player #Should send 'hello there'.", "send complex translated \"custom.message.key\" with inputs {_list-of-strings::*} to all players #Will send whatever this corresponds to in a custom language file."})
@Since(value="0.0.1")
public class SendComplexTranslatedMessage
extends Effect {
    private Expression<String> stringExpression;
    private Expression<String> inputsExpression;
    private Expression<Player> playerExpression;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.stringExpression = exprs[0];
        this.inputsExpression = exprs[1];
        this.playerExpression = exprs[2];
        return true;
    }

    protected void execute(Event event) {
        if (this.playerExpression == null || this.inputsExpression == null || this.stringExpression == null) {
            return;
        }
        for (String string : (String[])this.stringExpression.getArray(event)) {
            TranslatableComponent component = new TranslatableComponent(string, new Object[0]);
            for (String input : (String[])this.inputsExpression.getArray(event)) {
                component.addWith(input);
            }
            BaseComponent[] components = new ComponentBuilder((BaseComponent)component).create();
            for (Player player : (Player[])this.playerExpression.getArray(event)) {
                player.sendMessage(components);
            }
        }
    }

    public String toString(@Nullable Event event, boolean debug) {
        String string = "<none>";
        String player = "<none>";
        String inputs = "<none>";
        if (this.stringExpression != null) {
            string = this.stringExpression.toString(event, debug);
        }
        if (this.inputsExpression != null) {
            inputs = this.inputsExpression.toString(event, debug);
        }
        if (this.playerExpression != null) {
            player = this.playerExpression.toString(event, debug);
        }
        return "send simple translated messages " + string + " with inputs " + inputs + " to " + player;
    }

    static {
        Skript.registerEffect(SendComplexTranslatedMessage.class, (String[])new String[]{"send complex translated [message[s]] %strings% with [(attachment[s]|input[s])] %strings% to %players%"});
    }
}

