/*
 * Decompiled with CFR 0.152.
 */
package me.cybermaxke.merchants.api;

import javax.annotation.Nullable;
import me.cybermaxke.merchants.api.Merchant;
import me.cybermaxke.merchants.api.MerchantAPI;
import me.cybermaxke.merchants.api.MerchantOffer;
import org.bukkit.inventory.ItemStack;

public class Merchants {
    private static final String ERROR_INSTANCE_MISSING = "merchants api is not loaded";
    private static final String ERROR_SET_INSTANCE = "merchants api instance can only be set once";
    private static MerchantAPI instance;

    private static MerchantAPI getOrThrowError() {
        if (instance == null) {
            throw new IllegalStateException(ERROR_INSTANCE_MISSING);
        }
        return instance;
    }

    public static Merchant newMerchant(String title) {
        return Merchants.getOrThrowError().newMerchant(title);
    }

    public static Merchant newMerchant(String title, boolean jsonTitle) {
        return Merchants.getOrThrowError().newMerchant(title, jsonTitle);
    }

    public static MerchantOffer newOffer(ItemStack result, ItemStack firstItem, @Nullable ItemStack secondItem) {
        return Merchants.getOrThrowError().newOffer(result, firstItem, secondItem);
    }

    public static MerchantOffer newOffer(ItemStack result, ItemStack firstItem) {
        return Merchants.getOrThrowError().newOffer(result, firstItem);
    }

    public static MerchantAPI get() {
        return instance;
    }

    public static void set(MerchantAPI api) {
        if (instance != null) {
            throw new IllegalStateException(ERROR_SET_INSTANCE);
        }
        instance = api;
    }
}

