/*
 * Decompiled with CFR 0.152.
 */
package com.kh498.main.trader;

import com.google.common.base.Preconditions;
import com.kh498.main.TraderConfigManager;
import com.kh498.main.trader.Trader;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public class TradeMerchant {
    private final String internalName;
    private String displayName;
    private List<ItemStack> trades;

    public TradeMerchant(String name) {
        this.internalName = name;
        Trader.TraderSetTitle(this, name);
        this.setTrades(new ArrayList<ItemStack>());
    }

    public void saveMerchant(ConfigurationSection conf) {
        ConfigurationSection mainSection = TraderConfigManager.getSectionOrCreate(conf, this.internalName);
        if (mainSection.contains("Items")) {
            mainSection.set("Items", null);
        }
        ConfigurationSection tradesSection = TraderConfigManager.getSectionOrCreate(mainSection, "Items");
        mainSection.set("DisplayName", (Object)this.displayName);
        for (int i = 0; i < this.trades.size(); ++i) {
            tradesSection.set("Item " + i, (Object)this.trades.get(i));
        }
    }

    public String getInternalName() {
        return this.internalName;
    }

    public List<ItemStack> getTrades() {
        return this.trades;
    }

    public void setTrades(List<ItemStack> trades) {
        this.trades = trades;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        Preconditions.checkNotNull((Object)displayName);
        this.displayName = displayName;
    }
}

