/*
 * Decompiled with CFR 0.152.
 */
package com.kh498.main;

import com.kh498.main.Main;
import com.kh498.main.trader.TradeMerchant;
import com.kh498.main.trader.Trader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class TraderConfigManager {
    private static final String TRADERS_CONF_SEC = "Traders";
    private static YamlConfiguration traderConfig = null;
    private static File traderConfigFile = null;
    private static Plugin plugin = null;

    public static void init(Plugin p) {
        boolean mkDir;
        plugin = p;
        traderConfigFile = new File(p.getDataFolder().getAbsolutePath());
        if (!(traderConfigFile.exists() && traderConfigFile.isDirectory() || (mkDir = traderConfigFile.mkdir()))) {
            Main.getInstance().getLogger().log(Level.SEVERE, "Failed to create data folder directory");
        }
        traderConfigFile = new File(p.getDataFolder().getAbsolutePath(), "Traders.yml");
        try {
            boolean newFile;
            if (!traderConfigFile.exists() && !(newFile = traderConfigFile.createNewFile())) {
                Main.getInstance().getLogger().log(Level.SEVERE, "Failed to create trader trader config file");
            }
            traderConfig = YamlConfiguration.loadConfiguration((File)traderConfigFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveTraders(boolean log) {
        Map<String, TradeMerchant> traders = Trader.getTraders();
        if (traders.size() != 0) {
            try {
                ConfigurationSection configSec = TraderConfigManager.getSectionOrCreate((ConfigurationSection)traderConfig, TRADERS_CONF_SEC);
                for (TradeMerchant tm : traders.values()) {
                    tm.saveMerchant(configSec);
                }
                if (log) {
                    plugin.getLogger().info("Traders saved");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                plugin.getLogger().warning("Could not create sections for traders");
            }
        } else if (traderConfig.isSet(TRADERS_CONF_SEC)) {
            traderConfig.set(TRADERS_CONF_SEC, null);
        }
        try {
            TraderConfigManager.saveTraderConfig();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            plugin.getLogger().warning("Could not save traders");
        }
    }

    public static void removeTrader(TradeMerchant tm) {
        ConfigurationSection configSec = traderConfig.getConfigurationSection(TRADERS_CONF_SEC);
        if (configSec.contains(tm.getInternalName())) {
            configSec.set(tm.getInternalName(), null);
        }
    }

    public static ConfigurationSection getSectionOrCreate(ConfigurationSection parent, String sectionName) {
        ConfigurationSection section = parent.getConfigurationSection(sectionName);
        if (section == null) {
            section = parent.createSection(sectionName);
        }
        return section;
    }

    static void loadTraders() {
        Map map;
        ConfigurationSection mainSec = TraderConfigManager.getConfig().getConfigurationSection(TRADERS_CONF_SEC);
        try {
            map = mainSec.getValues(false);
        }
        catch (NullPointerException e) {
            Main.getInstance().getServer().getConsoleSender().sendMessage(Main.CHAT_PREFIX + "Could not find any traders to load");
            return;
        }
        HashMap<String, TradeMerchant> newMap = new HashMap<String, TradeMerchant>();
        for (Map.Entry entry : map.entrySet()) {
            ConfigurationSection itemSec;
            TradeMerchant newTM = new TradeMerchant((String)entry.getKey());
            ConfigurationSection traderSec = mainSec.getConfigurationSection((String)entry.getKey());
            if (traderSec.getString("DisplayName") != null) {
                newTM.setDisplayName(traderSec.getString("DisplayName"));
            }
            if ((itemSec = traderSec.getConfigurationSection("Items")) != null) {
                ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                Boolean foundNext = true;
                int nr = 0;
                while (foundNext.booleanValue()) {
                    if (itemSec.isItemStack("Item " + nr)) {
                        list.add(itemSec.getItemStack("Item " + nr));
                        ++nr;
                        continue;
                    }
                    foundNext = false;
                }
                newTM.setTrades(list);
            }
            newMap.put((String)entry.getKey(), newTM);
        }
        Trader.setTraders(newMap);
        Main.getInstance().getServer().getConsoleSender().sendMessage(Main.CHAT_PREFIX + "Traders loaded");
    }

    private static YamlConfiguration getConfig() {
        return traderConfig;
    }

    private static void saveTraderConfig() {
        if (traderConfig != null) {
            try {
                traderConfig.save(traderConfigFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

