/*
 * Decompiled with CFR 0.152.
 */
package me.cybermaxke.merchants.v18r3;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import me.cybermaxke.merchants.api.Merchant;
import me.cybermaxke.merchants.api.MerchantOffer;
import me.cybermaxke.merchants.api.MerchantTradeListener;
import me.cybermaxke.merchants.v18r3.SContainerMerchant;
import me.cybermaxke.merchants.v18r3.SMerchantOffer;
import net.minecraft.server.v1_8_R3.Container;
import net.minecraft.server.v1_8_R3.EntityHuman;
import net.minecraft.server.v1_8_R3.EntityPlayer;
import net.minecraft.server.v1_8_R3.IChatBaseComponent;
import net.minecraft.server.v1_8_R3.ICrafting;
import net.minecraft.server.v1_8_R3.IMerchant;
import net.minecraft.server.v1_8_R3.ItemStack;
import net.minecraft.server.v1_8_R3.MerchantRecipe;
import net.minecraft.server.v1_8_R3.MerchantRecipeList;
import net.minecraft.server.v1_8_R3.Packet;
import net.minecraft.server.v1_8_R3.PacketDataSerializer;
import net.minecraft.server.v1_8_R3.PacketPlayOutCustomPayload;
import net.minecraft.server.v1_8_R3.PacketPlayOutOpenWindow;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_8_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_8_R3.util.CraftChatMessage;
import org.bukkit.entity.Player;

public class SMerchant
implements IMerchant,
Merchant {
    protected final Set<MerchantTradeListener> handlers = Sets.newHashSet();
    private final MerchantRecipeList offers = new MerchantRecipeList();
    private final Set<Player> customers = Sets.newHashSet();
    protected SMerchantOffer onTrade;
    protected EntityPlayer onTradePlayer;
    private String title;
    private boolean jsonTitle;
    private IChatBaseComponent sendTitle;

    public SMerchant(String title, boolean jsonTitle) {
        this.setTitle(title, jsonTitle);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.setTitle(title, false);
    }

    @Override
    public boolean isTitleJson() {
        return this.jsonTitle;
    }

    @Override
    public void setTitle(String title, boolean jsonTitle) {
        IChatBaseComponent newTitle;
        Preconditions.checkNotNull((Object)title, (Object)"title");
        IChatBaseComponent oldTitle = this.sendTitle;
        if (jsonTitle) {
            try {
                newTitle = IChatBaseComponent.ChatSerializer.a((String)title);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("invalid json format (" + title + ")", e);
            }
        } else {
            newTitle = CraftChatMessage.fromString((String)title)[0];
        }
        this.sendTitle = newTitle;
        this.jsonTitle = jsonTitle;
        this.title = title;
        if (!this.sendTitle.equals(oldTitle)) {
            this.sendTitleUpdate();
        }
    }

    @Override
    public boolean addListener(MerchantTradeListener listener) {
        Preconditions.checkNotNull((Object)listener, (Object)"listener");
        return this.handlers.add(listener);
    }

    @Override
    public boolean removeListener(MerchantTradeListener listener) {
        Preconditions.checkNotNull((Object)listener, (Object)"listener");
        return this.handlers.remove(listener);
    }

    @Override
    public Collection<MerchantTradeListener> getListeners() {
        return Lists.newArrayList(this.handlers);
    }

    @Override
    public void addOffer(MerchantOffer offer) {
        Preconditions.checkNotNull((Object)offer, (Object)"offer");
        if (this.offers.contains((Object)offer)) {
            return;
        }
        this.offers.add((Object)((MerchantRecipe)offer));
        ((SMerchantOffer)offer).add(this);
        this.sendUpdate();
    }

    @Override
    public void addOffers(Iterable<MerchantOffer> offers) {
        Preconditions.checkNotNull(offers, (Object)"offers");
        if (!offers.iterator().hasNext()) {
            return;
        }
        for (MerchantOffer offer : offers) {
            if (this.offers.contains((Object)offer)) continue;
            this.offers.add((Object)((MerchantRecipe)offer));
            ((SMerchantOffer)offer).add(this);
        }
        this.sendUpdate();
    }

    @Override
    public void sortOffers(final Comparator<MerchantOffer> comparator) {
        Preconditions.checkNotNull(comparator, (Object)"comparator");
        if (this.offers.size() <= 1) {
            return;
        }
        Collections.sort(this.offers, new Comparator<MerchantRecipe>(){

            @Override
            public int compare(MerchantRecipe arg0, MerchantRecipe arg1) {
                return comparator.compare((MerchantOffer)arg0, (MerchantOffer)arg1);
            }
        });
        this.sendUpdate();
    }

    @Override
    public void removeOffer(MerchantOffer offer) {
        Preconditions.checkNotNull((Object)offer, (Object)"offer");
        if (this.offers.remove((Object)offer)) {
            ((SMerchantOffer)offer).remove(this);
            this.sendUpdate();
        }
    }

    @Override
    public void removeOffers(Iterable<MerchantOffer> offers) {
        Preconditions.checkNotNull(offers, (Object)"offers");
        if (offers.iterator().hasNext()) {
            return;
        }
        if (this.offers.removeAll((Collection)Lists.newArrayList(offers))) {
            for (MerchantOffer offer : offers) {
                ((SMerchantOffer)offer).remove(this);
            }
            this.sendUpdate();
        }
    }

    @Override
    public List<MerchantOffer> getOffers() {
        ArrayList offers = Lists.newArrayList();
        for (MerchantRecipe recipe : this.offers) {
            offers.add((MerchantOffer)recipe);
        }
        return offers;
    }

    @Override
    public MerchantOffer getOfferAt(int index) {
        if (index < 0 || index >= this.offers.size()) {
            throw new IndexOutOfBoundsException("index (" + index + ") out of bounds min (0) and max (" + this.offers.size() + ")");
        }
        return (MerchantOffer)this.offers.get(index);
    }

    @Override
    public int getOffersCount() {
        return this.offers.size();
    }

    @Override
    public void setOfferAt(int index, MerchantOffer offer) {
        Preconditions.checkNotNull((Object)offer, (Object)"offer");
        if (index < 0 || index >= this.offers.size()) {
            throw new IndexOutOfBoundsException("index (" + index + ") out of bounds min (0) and max (" + this.offers.size() + ")");
        }
        SMerchantOffer old = (SMerchantOffer)this.offers.set(index, (Object)((MerchantRecipe)offer));
        old.remove(this);
        this.sendUpdate();
    }

    @Override
    public void insetOfferAt(int index, MerchantOffer offer) {
        Preconditions.checkNotNull((Object)offer, (Object)"offer");
        if (index < 0 || index >= this.offers.size()) {
            throw new IndexOutOfBoundsException("index (" + index + ") out of bounds min (0) and max (" + this.offers.size() + ")");
        }
        this.offers.add(index, (Object)((MerchantRecipe)offer));
    }

    @Override
    public boolean addCustomer(Player player) {
        Preconditions.checkNotNull((Object)player, (Object)"player");
        if (this.customers.add(player)) {
            EntityPlayer player0 = ((CraftPlayer)player).getHandle();
            SContainerMerchant container0 = null;
            try {
                container0 = new SContainerMerchant(player0, this);
                container0 = CraftEventFactory.callInventoryOpenEvent((EntityPlayer)player0, (Container)container0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (container0 == null) {
                this.customers.remove(player);
                return false;
            }
            int window = player0.nextContainerCounter();
            player0.activeContainer = container0;
            player0.activeContainer.windowId = window;
            player0.activeContainer.addSlotListener((ICrafting)player0);
            player0.playerConnection.sendPacket((Packet)new PacketPlayOutOpenWindow(window, "minecraft:villager", this.sendTitle, 0));
            PacketDataSerializer content = new PacketDataSerializer(Unpooled.buffer());
            content.writeInt(window);
            this.offers.a(content);
            player0.playerConnection.sendPacket((Packet)new PacketPlayOutCustomPayload("MC|TrList", content));
            return true;
        }
        return false;
    }

    @Override
    public boolean removeCustomer(Player player) {
        Preconditions.checkNotNull((Object)player, (Object)"player");
        if (this.customers.remove(player)) {
            player.closeInventory();
            return true;
        }
        return false;
    }

    @Override
    public boolean hasCustomer(Player player) {
        Preconditions.checkNotNull((Object)player, (Object)"player");
        return this.customers.contains(player);
    }

    @Override
    public Collection<Player> getCustomers() {
        return Lists.newArrayList(this.customers);
    }

    public void a_(EntityHuman arg0) {
    }

    public EntityHuman v_() {
        return null;
    }

    public MerchantRecipeList getOffers(EntityHuman human) {
        return this.offers;
    }

    public void a(MerchantRecipe recipe) {
        this.onTrade = (SMerchantOffer)recipe;
    }

    public void a_(ItemStack arg0) {
    }

    public IChatBaseComponent getScoreboardDisplayName() {
        return this.sendTitle;
    }

    private void sendTitleUpdate() {
        for (Player customer : this.customers) {
            EntityPlayer player0 = ((CraftPlayer)customer).getHandle();
            player0.playerConnection.sendPacket((Packet)new PacketPlayOutOpenWindow(player0.activeContainer.windowId, "minecraft:villager", this.sendTitle, 0));
            player0.updateInventory(player0.activeContainer);
        }
    }

    void sendUpdate() {
        if (this.customers.isEmpty()) {
            return;
        }
        if (this.onTradePlayer != null && this.customers.size() <= 1) {
            return;
        }
        PacketDataSerializer content0 = new PacketDataSerializer(Unpooled.buffer());
        this.offers.a(content0);
        for (Player customer : this.customers) {
            EntityPlayer player0 = ((CraftPlayer)customer).getHandle();
            if (player0 == this.onTradePlayer) continue;
            PacketDataSerializer content1 = new PacketDataSerializer(Unpooled.buffer());
            content1.writeInt(player0.activeContainer.windowId);
            content1.writeBytes((ByteBuf)content0);
            player0.playerConnection.sendPacket((Packet)new PacketPlayOutCustomPayload("MC|TrList", content1));
        }
    }
}

