/*
 * Decompiled with CFR 0.152.
 */
package me.cybermaxke.merchants.v111r1;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import me.cybermaxke.merchants.api.MerchantOffer;
import me.cybermaxke.merchants.v111r1.SMerchant;
import net.minecraft.server.v1_11_R1.MerchantRecipe;
import org.bukkit.craftbukkit.v1_11_R1.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;

public class SMerchantOffer
extends MerchantRecipe
implements MerchantOffer {
    private final Set<SMerchant> merchants = Collections.newSetFromMap(new WeakHashMap());
    @Nullable
    private final ItemStack item1;
    @Nullable
    private final ItemStack item2;
    private final ItemStack result;
    private int maxUses = -1;
    private int uses;

    SMerchantOffer(ItemStack result, ItemStack item1, ItemStack item2) {
        super(null, null, null);
        this.result = result;
        this.item1 = item1;
        this.item2 = item2;
    }

    private static net.minecraft.server.v1_11_R1.ItemStack convertSafely(ItemStack itemStack) {
        if (itemStack == null || itemStack.getTypeId() == 0 || itemStack.getAmount() == 0) {
            return net.minecraft.server.v1_11_R1.ItemStack.a;
        }
        return CraftItemStack.asNMSCopy((ItemStack)itemStack);
    }

    void add(SMerchant merchant) {
        this.merchants.add(merchant);
    }

    void remove(SMerchant merchant) {
        this.merchants.remove(merchant);
    }

    @Override
    public ItemStack getFirstItem() {
        Preconditions.checkState((this.item1 != null ? 1 : 0) != 0, (Object)"The first item is not set");
        return this.item1.clone();
    }

    @Override
    public Optional<ItemStack> getSecondItem() {
        if (this.item2 == null) {
            return Optional.empty();
        }
        return Optional.of(this.item2.clone());
    }

    @Override
    public ItemStack getResultItem() {
        return this.result.clone();
    }

    @Override
    public int getMaxUses() {
        return this.maxUses;
    }

    @Override
    public void setMaxUses(int uses) {
        if (this.maxUses == uses) {
            return;
        }
        boolean locked0 = this.isLocked();
        this.maxUses = uses;
        boolean locked1 = this.isLocked();
        if (locked0 != locked1) {
            for (SMerchant merchant : this.merchants) {
                merchant.sendUpdate();
            }
        }
    }

    @Override
    public void addMaxUses(int extra) {
        if (this.maxUses >= 0 && extra != 0) {
            this.setMaxUses(this.maxUses + extra);
        }
    }

    @Override
    public int getUses() {
        return this.uses;
    }

    @Override
    public void setUses(int uses) {
        if (this.uses == uses) {
            return;
        }
        boolean locked0 = this.isLocked();
        this.uses = uses;
        boolean locked1 = this.isLocked();
        if (locked0 != locked1) {
            for (SMerchant merchant : this.merchants) {
                merchant.sendUpdate();
            }
        }
    }

    @Override
    public void addUses(int uses) {
        if (uses != 0) {
            this.setUses(this.uses + uses);
        }
    }

    @Override
    public boolean isLocked() {
        return this.maxUses >= 0 && this.uses >= this.maxUses;
    }

    public net.minecraft.server.v1_11_R1.ItemStack getBuyItem1() {
        return SMerchantOffer.convertSafely(this.item1);
    }

    public net.minecraft.server.v1_11_R1.ItemStack getBuyItem2() {
        return SMerchantOffer.convertSafely(this.item2);
    }

    public boolean hasSecondItem() {
        return this.item2 != null;
    }

    public net.minecraft.server.v1_11_R1.ItemStack getBuyItem3() {
        return SMerchantOffer.convertSafely(this.result);
    }

    public int e() {
        return this.uses;
    }

    public int f() {
        return this.maxUses < 0 ? Integer.MAX_VALUE : this.maxUses;
    }

    public void g() {
        this.addUses(1);
    }

    public void a(int extra) {
        this.addMaxUses(extra);
    }

    public boolean h() {
        return this.isLocked();
    }

    public boolean j() {
        return false;
    }

    @Override
    public SMerchantOffer clone() {
        ItemStack result = this.getResultItem();
        ItemStack item1 = this.getFirstItem();
        ItemStack item2 = this.item2 != null ? this.item2.clone() : null;
        SMerchantOffer clone = new SMerchantOffer(result, item1, item2);
        clone.maxUses = this.maxUses;
        clone.uses = this.uses;
        return clone;
    }
}

