/*
 * Decompiled with CFR 0.152.
 */
package com.kh498.main.trader;

import ch.njol.skript.Skript;
import ch.njol.skript.log.ErrorQuality;
import com.google.common.base.Preconditions;
import com.kh498.main.Main;
import com.kh498.main.MainConfigManager;
import com.kh498.main.TraderConfigManager;
import com.kh498.main.trader.TradeMerchant;
import com.kh498.main.util.Util;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import me.cybermaxke.merchants.api.Merchant;
import me.cybermaxke.merchants.api.MerchantAPI;
import me.cybermaxke.merchants.api.Merchants;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class Trader {
    private static Map<String, TradeMerchant> traders = new HashMap<String, TradeMerchant>();

    public static TradeMerchant getTradeMerchant(String name) {
        return traders.get(name);
    }

    public static void TraderNew(String traderName) {
        traders.put(traderName, new TradeMerchant(traderName));
    }

    public static void TraderSetTitle(TradeMerchant trader, String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        Preconditions.checkNotNull((Object)trader);
        String oldName = trader.getDisplayName();
        String newName = Util.toJSON(name);
        Main.log("new JSON name: " + newName);
        if (oldName != null && oldName.equals(newName)) {
            Main.log("");
            return;
        }
        trader.setDisplayName(newName);
    }

    public static void TraderRemove(TradeMerchant trader) {
        Preconditions.checkNotNull((Object)trader);
        if (traders.containsKey(trader.getInternalName())) {
            TraderConfigManager.removeTrader(trader);
            traders.remove(trader.getInternalName());
        }
    }

    public static void TraderRemoveAll() {
        traders.clear();
    }

    public static void TraderRemovePage(TradeMerchant trader, int page) {
        Preconditions.checkNotNull((Object)trader);
        List<ItemStack> list = trader.getTrades();
        if (list.isEmpty()) {
            return;
        }
        int pages = Util.getPages(list);
        if (0 > page) {
            Skript.error((String)"The requested page number is too low, it cannot be lower than 0");
            return;
        }
        if (page >= pages) {
            Skript.error((String)("The requested page number is too high, it cannot be higher than " + pages));
            return;
        }
        page *= 3;
        if (pages <= 0) {
            list.clear();
            return;
        }
        Main.log("Going to remove: " + list.get(page) + ", " + list.get(page + 1) + " and " + list.get(page + 2));
        Main.log("before removing: " + list);
        for (int i = 2; i >= 0; --i) {
            list.remove(page + i);
        }
        trader.setTrades(list);
        Main.log("after removing: " + list);
    }

    public static void TraderSetPage(TradeMerchant trader, int page, ItemStack outputItem, ItemStack inputItem1, @Nullable ItemStack inputItem2) {
        String mode;
        String itemOUT;
        Preconditions.checkNotNull((Object)trader);
        List<ItemStack> tradesList = trader.getTrades();
        if ((page *= 3) < 0) {
            Skript.error((String)"The requested page number is too low, it cannot be lower than 0");
            return;
        }
        if (tradesList.size() < page) {
            try {
                tradesList.get(page - 1);
            }
            catch (IndexOutOfBoundsException e) {
                Skript.error((String)("Could not add items to page " + page / 3 + " as there are no items in the previous page."));
                return;
            }
            Skript.error((String)("Could not add items to page " + page / 3 + " as there are no items in the previous page."));
            return;
        }
        ItemStack itemIn = null;
        if (inputItem1 == null && inputItem2 != null) {
            itemIn = inputItem2;
        } else if (inputItem2 == null && inputItem1 != null) {
            itemIn = inputItem1;
        }
        if (!(Util.isValidMaterial(outputItem, false) && Util.isValidMaterial(inputItem1, false) && Util.isValidMaterial(inputItem2, true) && Util.isValidMaterial(itemIn, true))) {
            Main.log("Invalid material");
            return;
        }
        try {
            itemOUT = "" + tradesList.get(page);
            mode = "set";
        }
        catch (IndexOutOfBoundsException e) {
            itemOUT = "NONE";
            mode = "add";
        }
        if (MainConfigManager.getMainConfig().getBoolean("debug")) {
            String itemIN2;
            String itemIN1;
            int pages = Util.getPages(tradesList);
            try {
                itemIN1 = "" + tradesList.get(page + 1);
            }
            catch (IndexOutOfBoundsException e) {
                itemIN1 = "NONE";
            }
            try {
                itemIN2 = "" + tradesList.get(page + 2);
            }
            catch (IndexOutOfBoundsException e) {
                itemIN2 = "NONE";
            }
            Main.log("itemOUT: " + itemOUT + " | itemIN1: " + itemIN1 + " | itemIN2: " + itemIN2 + "\noutputItem: " + outputItem + " inputItem1: " + inputItem1 + " inputItem2: " + inputItem2 + " itemIn: " + itemIn + "\nindex: " + page + " size: " + tradesList.size() + " pages: " + pages);
            Main.log("itemOUT: " + itemOUT + "itemIN1: " + itemIN1 + "itemIN2: " + itemIN2 + " | index: " + page);
        }
        if ("set".equals(mode)) {
            tradesList.set(page, outputItem);
            Main.log("outputItem: set");
        } else {
            Main.log("outputItem: add");
            tradesList.add(outputItem);
        }
        if (itemIn != null) {
            ItemStack air = new ItemStack(Material.AIR);
            if ("set".equals(mode)) {
                Main.log("itemIn: set");
                tradesList.set(page + 1, itemIn);
                tradesList.set(page + 2, air);
            } else {
                Main.log("itemIn: add");
                tradesList.add(itemIn);
                tradesList.add(air);
            }
        } else if ("set".equals(mode)) {
            Main.log("inputItem1: set");
            tradesList.set(page + 1, inputItem1);
            tradesList.set(page + 2, inputItem2);
        } else {
            Main.log("inputItem2: add");
            tradesList.add(inputItem1);
            tradesList.add(inputItem2);
        }
        trader.setTrades(tradesList);
    }

    public static void TraderListPages(TradeMerchant trader, Player player) {
        Preconditions.checkNotNull((Object)trader);
        List<ItemStack> list = trader.getTrades();
        int pages = Util.getPages(list);
        String ShowInputItem2 = "empty";
        String ShowInputItem1 = "empty";
        String ShowOutputItem = "empty";
        player.sendMessage(ChatColor.GOLD + "Trader " + trader.getDisplayName() + "'s (internal name: '" + trader.getInternalName() + "') items");
        player.sendMessage(ChatColor.GRAY + "There are " + pages + " page(s):");
        for (int pageNr = 0; pageNr < pages; ++pageNr) {
            int page = pageNr * 3;
            ItemStack outputItem = list.get(page);
            ItemStack inputItem1 = list.get(page + 1);
            ItemStack inputItem2 = list.get(page + 2);
            if (Util.isValidMaterial(outputItem, false)) {
                ShowOutputItem = outputItem.getType().toString().toLowerCase();
            }
            if (Util.isValidMaterial(inputItem1, false)) {
                ShowInputItem1 = inputItem1.getType().toString().toLowerCase();
            }
            if (Util.isValidMaterial(inputItem2, true)) {
                ShowInputItem2 = inputItem2.getType().toString().toLowerCase();
            }
            player.sendMessage(ChatColor.YELLOW + "" + pageNr + ": " + ShowOutputItem + ", " + ShowInputItem1 + " and " + ShowInputItem2);
        }
    }

    public static void TraderOpen(TradeMerchant trader, Player player) {
        Merchant merchant;
        Preconditions.checkNotNull((Object)trader);
        if (player == null) {
            return;
        }
        List<ItemStack> tradesList = trader.getTrades();
        if (tradesList.size() == 0 && !MainConfigManager.getMainConfig().getBoolean("openEmptyTraders")) {
            return;
        }
        int pages = Util.getPages(tradesList);
        Main.log("Nr of pages: " + pages + " | Size of item list: " + tradesList.size());
        MerchantAPI api = Merchants.get();
        try {
            Main.log("Raw Merchant name: " + trader.getDisplayName());
            merchant = api.newMerchant(trader.getDisplayName(), true);
        }
        catch (NullPointerException e) {
            throw Skript.exception((Throwable)e, (String[])new String[]{"Could not open merchant as the api is not enabled."});
        }
        for (int i = 0; i < pages; ++i) {
            ItemStack inputItem2;
            int page = i * 3;
            ItemStack outputItem = tradesList.get(page);
            ItemStack inputItem1 = tradesList.get(page + 1);
            try {
                inputItem2 = tradesList.get(page + 2);
            }
            catch (IndexOutOfBoundsException e) {
                inputItem2 = null;
            }
            if (inputItem2 == null || inputItem2.getType().equals((Object)Material.AIR)) {
                inputItem2 = null;
            }
            if (Util.isValidMaterial(inputItem2, true)) {
                merchant.addOffer(api.newOffer(outputItem, inputItem1, inputItem2));
                continue;
            }
            if (Util.isValidMaterial(outputItem, false) && Util.isValidMaterial(inputItem1, false)) {
                merchant.addOffer(api.newOffer(outputItem, inputItem1));
                continue;
            }
            Skript.error((String)"Could not add offer as the item either was illegal or does not exist.", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
        }
        merchant.addCustomer(player);
    }

    public static Map<String, TradeMerchant> getTraders() {
        return traders;
    }

    public static void setTraders(Map<String, TradeMerchant> newTraders) {
        traders = newTraders;
    }
}

