/*
 * Decompiled with CFR 0.152.
 */
package com.kh498.main;

import com.kh498.main.Main;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.logging.Level;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class MainConfigManager {
    public static final String DEBUG_PATH = "debug";
    public static final String OPEN_EMPTY_PATH = "openEmptyTraders";
    private static final String CONF_NAME = "config.yml";
    private static YamlConfiguration myConfig;

    public static void init(Plugin p) {
        File configFile = new File(p.getDataFolder(), CONF_NAME);
        if (configFile.exists()) {
            myConfig = new YamlConfiguration();
            try {
                p.getLogger().info("Main config loaded");
                myConfig.load(configFile);
            }
            catch (Exception ex) {
                p.getLogger().warning("Failed to load config.yml (try to delete it)");
                ex.printStackTrace();
            }
        } else {
            try {
                if (!p.getDataFolder().mkdir()) {
                    Main.getInstance().getLogger().log(Level.SEVERE, "Failed to create data folder!");
                }
                InputStream jarURL = MainConfigManager.class.getResourceAsStream("/config.yml");
                MainConfigManager.copyFile(jarURL, configFile);
                myConfig = new YamlConfiguration();
                myConfig.load(configFile);
                p.getLogger().info("Main config created");
            }
            catch (Exception ex) {
                p.getLogger().warning("Failed to create config.yml from the jar");
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(InputStream in, File out) throws Exception {
        try (FileOutputStream fos = new FileOutputStream(out);){
            int i;
            byte[] buf = new byte[1024];
            while ((i = in.read(buf)) != -1) {
                fos.write(buf, 0, i);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static YamlConfiguration getMainConfig() {
        return myConfig;
    }
}

