/*
 * Decompiled with CFR 0.152.
 */
package com.kh498.main;

import ch.njol.skript.Skript;
import com.kh498.main.MainConfigManager;
import com.kh498.main.Register;
import com.kh498.main.TraderConfigManager;
import com.kh498.main.util.Util;
import java.util.logging.Level;
import me.cybermaxke.merchants.SMerchantPlugin;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin {
    static String CHAT_PREFIX;
    private static Plugin instance;
    private static boolean DEBUG;
    private final String MCVersion = Util.getNmsVersion();
    private boolean enabled;

    static Plugin getInstance() {
        return instance;
    }

    public static void log(String msg) {
        if (DEBUG) {
            Main.getInstance().getLogger().log(Level.INFO, msg);
        }
    }

    public void onDisable() {
        if (this.enabled) {
            TraderConfigManager.saveTraders(true);
        }
    }

    public void onEnable() {
        boolean versionMatch;
        CHAT_PREFIX = "[" + this.getName() + "] ";
        if (Bukkit.getPluginManager().getPlugin("Skript") == null) {
            this.getServer().getConsoleSender().sendMessage(CHAT_PREFIX + ChatColor.RED + "Could not enable the plugin! This is an addon to Skript by Njol and cannot function without it.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        instance = this;
        TraderConfigManager.init((Plugin)this);
        MainConfigManager.init((Plugin)this);
        DEBUG = MainConfigManager.getMainConfig().getBoolean("debug");
        boolean register = false;
        boolean oldVersion = false;
        boolean hasMerchants = Bukkit.getPluginManager().getPlugin("Merchants") != null;
        String externalAPIVersion = Bukkit.getPluginManager().getPlugin("Merchants").getDescription().getVersion();
        String internalAPIVersion = "1.5.1";
        if (hasMerchants) {
            if (externalAPIVersion.equals("1.5.1")) {
                this.getLogger().info("Found plugins Merchants using the same version the API (" + externalAPIVersion + "). Using that instead of the internal version.");
            } else if (this.isUsingOldAPI(externalAPIVersion)) {
                if (this.supportedMCVersions()) {
                    Plugin plugin = Bukkit.getPluginManager().getPlugin("Merchants");
                    this.getServer().getPluginManager().disablePlugin(plugin);
                    oldVersion = true;
                    this.getLogger().info("Found plugins Merchants but its using an old version of the API (" + externalAPIVersion + "). The plugin will be disabled and an internal, newer version (" + "1.5.1" + "), will be used in it's place.");
                } else {
                    this.getLogger().info("Found plugins Merchants but its using an old version or the same version of the API (" + externalAPIVersion + "). Consider updating it.");
                }
            }
        }
        if (!hasMerchants || oldVersion) {
            SMerchantPlugin SMerchantPlugin2 = new SMerchantPlugin(this);
            versionMatch = SMerchantPlugin2.Enable();
            if (!hasMerchants && versionMatch) {
                this.getLogger().info("Could not find plugin Merchants, using internal API version 1.5.1 with minecraft server version " + this.MCVersion);
            }
        } else {
            versionMatch = true;
            this.getLogger().info("Using external Merchants plugin with the version" + externalAPIVersion);
        }
        if (versionMatch) {
            Skript.registerAddon((JavaPlugin)this);
            if (Skript.isAcceptRegistrations()) {
                Register.RegisterMerchants();
                try {
                    TraderConfigManager.loadTraders();
                }
                catch (NullPointerException e) {
                    this.getLogger().warning("Could not load traders due to you possibly using an old version of the config file! to fix this simply delete the config.yml in /plugins/tradersk/");
                    e.printStackTrace();
                }
                register = true;
            } else {
                Skript.error((String)"Could not register effects as skript is not accepting registrations.");
            }
        }
        if (!versionMatch || !register) {
            this.getServer().getConsoleSender().sendMessage(CHAT_PREFIX + ChatColor.RED + "Could not enable the plugin! Due to no internal support for minecraft version " + this.MCVersion + "! Please use the plugin Merchants by cybermaxke if you want to use this addon.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        } else {
            this.getLogger().info("Merchants effects added!");
            this.getLogger().info("Enabled ~ Created by kh498");
            this.enabled = true;
        }
    }

    private boolean isUsingOldAPI(String externalVer) {
        switch (externalVer) {
            case "1.5.0-SNAPSHOT": 
            case "1.4.0-SNAPSHOT": 
            case "1.3.0-SNAPSHOT": 
            case "1.2.0-SNAPSHOT": 
            case "1.2-SNAPSHOT": 
            case "1.1.1-SNAPSHOT": 
            case "1.1.0-SNAPSHOT": 
            case "1.0.1-SNAPSHOT": 
            case "1.0.0-SNAPSHOT": {
                return true;
            }
        }
        return false;
    }

    private boolean supportedMCVersions() {
        switch (this.MCVersion) {
            case "v111r1": 
            case "v110r1": 
            case "v19r2": 
            case "v18r3": {
                return true;
            }
        }
        return false;
    }
}

