/*
 * Decompiled with CFR 0.152.
 */
package com.kh498.main.util;

import ch.njol.skript.Skript;
import com.kh498.main.MainConfigManager;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class Util {
    public static String getNmsVersion() {
        String version = Bukkit.getServer().getClass().getPackage().getName().replace("org.bukkit.craftbukkit", "").replaceFirst(".", "");
        if ((version = version.replace("_", "").toLowerCase()).isEmpty()) {
            version = "unknown";
        }
        return version;
    }

    public static boolean isValidMaterial(ItemStack item, boolean canBeNull) {
        if (item == null) {
            if (MainConfigManager.getMainConfig().getBoolean("debug")) {
                Skript.error((String)"Material was null when validating it");
            }
            return canBeNull;
        }
        Material itemType = item.getType();
        switch (itemType) {
            case AIR: 
            case WATER: 
            case LAVA: 
            case STATIONARY_LAVA: 
            case BED_BLOCK: 
            case PISTON_EXTENSION: 
            case PISTON_MOVING_PIECE: 
            case FIRE: 
            case REDSTONE_WIRE: 
            case SIGN_POST: 
            case WOODEN_DOOR: 
            case WALL_SIGN: 
            case IRON_DOOR_BLOCK: 
            case SUGAR_CANE_BLOCK: 
            case PORTAL: 
            case CAKE_BLOCK: 
            case DIODE_BLOCK_OFF: 
            case DIODE_BLOCK_ON: 
            case MELON_STEM: 
            case NETHER_WARTS: 
            case BREWING_STAND: 
            case CAULDRON: 
            case ENDER_PORTAL: 
            case REDSTONE_LAMP_ON: 
            case COCOA: 
            case TRIPWIRE: 
            case FLOWER_POT: 
            case CARROT: 
            case POTATO: 
            case SKULL: 
            case REDSTONE_COMPARATOR_OFF: 
            case REDSTONE_COMPARATOR_ON: 
            case DOUBLE_STONE_SLAB2: 
            case SPRUCE_DOOR: 
            case BIRCH_DOOR: 
            case JUNGLE_DOOR: 
            case ACACIA_DOOR: 
            case DARK_OAK_DOOR: {
                Skript.error((String)("Illegal material for one of the items '" + item.getType() + "'"));
                return false;
            }
        }
        return true;
    }

    public static int getPages(List<ItemStack> list) {
        return Math.floorDiv(list.size() + 1, 3);
    }

    public static String getJSON(String title) {
        char colorChar = '\u00a7';
        String template = "{text:\"TEXT\",color:COLOR,bold:BOLD,underlined:UNDERLINED,italic:ITALIC,strikethrough:STRIKETHROUGH,obfuscated:OBFUSCATED,extra:[EXTRA]}";
        String json = "";
        ArrayList<String> parts = new ArrayList<String>();
        int first = 0;
        int last = 0;
        while ((first = title.indexOf(colorChar, last)) != -1) {
            int offset = 2;
            while ((last = title.indexOf(colorChar, first + offset)) - 2 == first) {
                offset += 2;
            }
            if (last == -1) {
                parts.add(title.substring(first));
                break;
            }
            parts.add(title.substring(first, last));
        }
        if (parts.isEmpty()) {
            parts.add(title);
        }
        Pattern colorFinder = Pattern.compile("(" + colorChar + "([a-f0-9]))");
        for (String part : parts) {
            json = json.isEmpty() ? template : json.replace("EXTRA", template);
            Matcher matcher = colorFinder.matcher(part);
            ChatColor color = matcher.find() ? ChatColor.getByChar((char)matcher.group().charAt(1)) : ChatColor.WHITE;
            json = json.replace("COLOR", color.name().toLowerCase());
            json = json.replace("BOLD", String.valueOf(part.contains(ChatColor.BOLD.toString())));
            json = json.replace("ITALIC", String.valueOf(part.contains(ChatColor.ITALIC.toString())));
            json = json.replace("UNDERLINED", String.valueOf(part.contains(ChatColor.UNDERLINE.toString())));
            json = json.replace("STRIKETHROUGH", String.valueOf(part.contains(ChatColor.STRIKETHROUGH.toString())));
            json = json.replace("OBFUSCATED", String.valueOf(part.contains(ChatColor.MAGIC.toString())));
            json = json.replace("TEXT", part.replaceAll("(" + colorChar + "([a-z0-9]))", ""));
        }
        json = json.replace(",extra:[EXTRA]", "");
        return json;
    }
}

