/*
 * Decompiled with CFR 0.152.
 */
package com.kh498.main.trader;

import ch.njol.skript.Skript;
import ch.njol.skript.log.ErrorQuality;
import com.google.common.base.Preconditions;
import com.kh498.main.ConfigManager;
import com.kh498.main.trader.TradeMerchant;
import com.kh498.main.util.Util;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import me.cybermaxke.merchants.api.Merchant;
import me.cybermaxke.merchants.api.MerchantAPI;
import me.cybermaxke.merchants.api.Merchants;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class Trader {
    private static Map<String, TradeMerchant> traders = new HashMap<String, TradeMerchant>();
    public static final boolean debug = false;

    public static TradeMerchant getTradeMerchant(String name) {
        return traders.get(name) != null ? traders.get(name) : null;
    }

    public static void TraderNew(String traderName) {
        traders.put(traderName, new TradeMerchant(traderName, null));
    }

    public static void TraderSetTitle(TradeMerchant trader, String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        Preconditions.checkNotNull((Object)trader);
        String oldName = trader.getDisplayName();
        if (oldName != null && oldName.equals(name)) {
            return;
        }
        trader.setDisplayName(name);
    }

    public static void TraderRemove(TradeMerchant trader) {
        Preconditions.checkNotNull((Object)trader);
        if (traders.containsKey(trader.getInternalName())) {
            ConfigManager.removeTrader(trader);
            traders.remove(trader.getInternalName());
        }
    }

    public static void TraderRemoveAll() {
        traders.clear();
    }

    public static void TraderRemovePage(TradeMerchant trader, int page) {
        Preconditions.checkNotNull((Object)trader);
        List<ItemStack> list = trader.getTrades();
        if (list.isEmpty()) {
            return;
        }
        int pages = Util.getPages(list);
        if (page < 0) {
            Skript.error((String)"The requested page number is too low, it cannot be lower than 0");
            return;
        }
        if (page >= pages) {
            Skript.error((String)("The requested page number is too high, it cannot be higher than " + pages));
            return;
        }
        page *= 3;
        if (pages <= 0) {
            list.clear();
            return;
        }
        int i = 2;
        while (i >= 0) {
            list.remove(page + i);
            --i;
        }
        trader.setTrades(list);
    }

    public static void TraderSetPage(TradeMerchant trader, int page, ItemStack item0, ItemStack item1, @Nullable ItemStack item2) {
        String mode;
        Preconditions.checkNotNull((Object)trader);
        List<ItemStack> list = trader.getTrades();
        if (page < 0) {
            Skript.error((String)"The requested page number is too low, it cannot be lower than 0");
            return;
        }
        if (page != 0) {
            try {
                list.get(page - 1);
            }
            catch (IndexOutOfBoundsException e) {
                Skript.error((String)("Could not add items to page " + page + " as there are no items in the previous page."));
                return;
            }
        }
        page *= 3;
        ItemStack itemIn = null;
        if (item1 == null && item2 != null) {
            itemIn = item2;
        } else if (item2 == null && item1 != null) {
            itemIn = item1;
        }
        if (!(Util.isValidMaterial(item0, false) && Util.isValidMaterial(item1, false) && Util.isValidMaterial(item2, true) && Util.isValidMaterial(itemIn, true))) {
            return;
        }
        try {
            String itemOUT = "" + list.get(page);
            mode = "set";
        }
        catch (IndexOutOfBoundsException e) {
            String itemOUT = "NONE";
            mode = "add";
        }
        if (mode == "set") {
            list.set(page, item0);
        } else {
            list.add(item0);
        }
        if (itemIn != null) {
            ItemStack air = new ItemStack(Material.AIR);
            if (mode == "set") {
                list.set(page + 1, itemIn);
                list.set(page + 2, air);
            } else {
                list.add(itemIn);
                list.add(air);
            }
        } else if (mode == "set") {
            list.set(page + 1, item1);
            list.set(page + 2, item2);
        } else {
            list.add(item1);
            list.add(item2);
        }
        trader.setTrades(list);
    }

    public static void TraderListPages(TradeMerchant trader, Player player) {
        Preconditions.checkNotNull((Object)trader);
        List<ItemStack> list = trader.getTrades();
        int pages = Util.getPages(list);
        String ShowItem2 = "empty";
        String ShowItem1 = "empty";
        String ShowItem0 = "empty";
        player.sendMessage(ChatColor.GOLD + "Trader " + trader.getDisplayName() + "'s items");
        player.sendMessage(ChatColor.GRAY + "There are " + pages + " page(s):");
        int i = 0;
        while (i < pages) {
            int page = i * 3;
            ItemStack item0 = list.get(page);
            ItemStack item1 = list.get(page + 1);
            ItemStack item2 = list.get(page + 2);
            if (Util.isValidMaterial(item0, false)) {
                ShowItem0 = item0.getType().toString().toLowerCase();
            }
            if (Util.isValidMaterial(item1, false)) {
                ShowItem1 = item1.getType().toString().toLowerCase();
            }
            if (Util.isValidMaterial(item2, true)) {
                ShowItem2 = item2.getType().toString().toLowerCase();
            }
            player.sendMessage(ChatColor.YELLOW + i + ": " + ShowItem0 + ", " + ShowItem1 + " and " + ShowItem2);
            ++i;
        }
    }

    public static void TraderOpen(TradeMerchant trader, Player player) {
        Merchant merchant;
        Preconditions.checkNotNull((Object)trader);
        List<ItemStack> list = trader.getTrades();
        if (list.size() == 0) {
            return;
        }
        int pages = Util.getPages(list);
        MerchantAPI api = Merchants.get();
        try {
            merchant = api.newMerchant(trader.getDisplayName());
            merchant.setTitle(trader.getDisplayName());
        }
        catch (NullPointerException e) {
            Skript.exception((Throwable)e, (String[])new String[]{"Could not open merchant as the api is not enabled."});
            return;
        }
        int i = 0;
        while (i < pages) {
            ItemStack item2;
            int page = i * 3;
            ItemStack item0 = list.get(page);
            ItemStack item1 = list.get(page + 1);
            try {
                item2 = list.get(page + 2);
            }
            catch (IndexOutOfBoundsException e) {
                item2 = null;
            }
            if (item2.getType().equals((Object)Material.getMaterial((String)"AIR"))) {
                item2 = null;
            }
            if (Util.isValidMaterial(item2, true)) {
                merchant.addOffer(api.newOffer(item0, item1, item2));
            } else if (Util.isValidMaterial(item0, false) && Util.isValidMaterial(item1, false)) {
                merchant.addOffer(api.newOffer(item0, item1));
            } else {
                Skript.error((String)"Could not add offer as the item either was illegal or does not exist.", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            }
            ++i;
        }
        merchant.addCustomer(player);
    }

    public static Map<String, TradeMerchant> getTraders() {
        return traders;
    }

    public static void setTraders(Map<String, TradeMerchant> newTraders) {
        traders = newTraders;
    }
}

