/*
 * Decompiled with CFR 0.152.
 */
package com.kh498.main.trader;

import com.google.common.base.Preconditions;
import com.kh498.main.ConfigManager;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.craftbukkit.libs.jline.internal.Nullable;
import org.bukkit.inventory.ItemStack;

public class TradeMerchant {
    private String displayName;
    private String internalName;
    private List<ItemStack> trades;

    public TradeMerchant(String name, @Nullable ArrayList<ItemStack> traders) {
        this.internalName = name;
        this.setDisplayName(name);
        if (traders != null) {
            this.setTrades(traders);
        } else {
            this.setTrades(new ArrayList<ItemStack>());
        }
    }

    public void saveMerchant(ConfigurationSection conf) {
        ConfigurationSection mainSection = ConfigManager.getSectionOrCreate(conf, this.internalName);
        if (mainSection.contains("Items")) {
            mainSection.set("Items", null);
        }
        ConfigurationSection tradesSection = ConfigManager.getSectionOrCreate(mainSection, "Items");
        mainSection.set("DisplayName", (Object)this.displayName);
        int i = 0;
        while (i < this.trades.size()) {
            tradesSection.set("Item " + i, (Object)this.trades.get(i));
            ++i;
        }
    }

    public String getInternalName() {
        return this.internalName;
    }

    public List<ItemStack> getTrades() {
        return this.trades;
    }

    public void setTrades(List<ItemStack> trades) {
        this.trades = trades;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        Preconditions.checkNotNull((Object)displayName);
        this.displayName = displayName;
    }
}

