/*
 * Decompiled with CFR 0.152.
 */
package com.kh498.main.trader;

import ch.njol.skript.Skript;
import ch.njol.skript.log.ErrorQuality;
import com.kh498.main.Main;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import me.cybermaxke.merchants.api.Merchant;
import me.cybermaxke.merchants.api.MerchantAPI;
import me.cybermaxke.merchants.api.Merchants;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class Trader {
    private static Map<String, Object> Traders = new HashMap<String, Object>();
    private static boolean debug = false;
    private static Main main;

    public Trader(Main instance) {
        main = instance;
    }

    public static void TraderNew(String trader) {
        ArrayList list = new ArrayList(3);
        Traders.put(trader, list);
    }

    public static void TraderRemove(String trader) {
        if (!Trader.validTrader(trader)) {
            return;
        }
        List list = (List)Traders.get(trader);
        if (list.isEmpty()) {
            return;
        }
        list.clear();
        Traders.remove(trader);
        main.saveTraders(false);
    }

    public static void TraderRemoveAll() {
        Traders.clear();
        HashMap emptyMap = new HashMap();
        main.getConfig().createSection("Traders", emptyMap);
    }

    public static void TraderRemovePage(String trader, int page) {
        if (!Trader.validTrader(trader)) {
            return;
        }
        List list = (List)Traders.get(trader);
        if (list.isEmpty()) {
            return;
        }
        int pages = Trader.getPages(list);
        if (page < 0) {
            Skript.error((String)"The requested page number is too low, it cannot be lower than 0");
            return;
        }
        if (page > pages) {
            Skript.error((String)("The requested page number is too high, it cannot be higher than " + pages));
            return;
        }
        page *= 3;
        if (pages <= 0) {
            list.clear();
            return;
        }
        if (debug) {
            Skript.error((String)("Going to remove: " + list.get(page) + ", " + list.get(page + 1) + " and " + list.get(page + 2)));
            Skript.error((String)("before: " + list));
        }
        int i = 2;
        while (i >= 0) {
            list.remove(page + i);
            --i;
        }
        Traders.replace(trader, list);
        main.saveTraders(false);
        if (debug) {
            Skript.error((String)("after:  " + list));
        }
    }

    public static void TraderSetPage(String trader, int page, ItemStack item0, ItemStack item1, @Nullable ItemStack item2) {
        String mode;
        String itemOUT;
        if (!Trader.validTrader(trader)) {
            return;
        }
        List list = (List)Traders.get(trader);
        if (page < 0) {
            Skript.error((String)"The requested page number is too low, it cannot be lower than 0");
            return;
        }
        if (page != 0) {
            try {
                list.get(page - 1);
            }
            catch (IndexOutOfBoundsException e) {
                Skript.error((String)("Could not add items to page " + page + " as there are no items in the previous page."));
                return;
            }
        }
        page *= 3;
        ItemStack itemIn = null;
        if (item1 == null && item2 != null) {
            itemIn = item2;
        } else if (item2 == null && item1 != null) {
            itemIn = item1;
        }
        if (!(Trader.isValidMaterial(item0, false) && Trader.isValidMaterial(item1, false) && Trader.isValidMaterial(item2, true) && Trader.isValidMaterial(itemIn, true))) {
            return;
        }
        try {
            itemOUT = "" + list.get(page);
            mode = "set";
        }
        catch (IndexOutOfBoundsException e) {
            itemOUT = "NONE";
            mode = "add";
        }
        if (debug) {
            String itemIN2;
            String itemIN1;
            int pages = Trader.getPages(list);
            try {
                itemIN1 = "" + list.get(page + 1);
            }
            catch (IndexOutOfBoundsException e) {
                itemIN1 = "NONE";
            }
            try {
                itemIN2 = "" + list.get(page + 2);
            }
            catch (IndexOutOfBoundsException e) {
                itemIN2 = "NONE";
            }
            System.out.println("itemOUT: " + itemOUT + " | itemIN1: " + itemIN1 + " | itemIN2: " + itemIN2 + "\nitem0: " + item0 + " item1: " + item1 + " item2: " + item2 + " itemIn: " + itemIn + "\nindex: " + page + " size: " + list.size() + " pages: " + pages);
            Skript.error((String)("itemOUT: " + itemOUT + "itemIN1: " + itemIN1 + "itemIN2: " + itemIN2 + " | index: " + page));
        }
        if (mode == "set") {
            list.set(page, item0);
            if (debug) {
                Skript.error((String)"item0: set");
            }
        } else {
            if (debug) {
                Skript.error((String)"item0: add");
            }
            list.add(item0);
        }
        if (itemIn != null) {
            ItemStack air = new ItemStack(Material.AIR);
            if (mode == "set") {
                if (debug) {
                    Skript.error((String)"itemIn: set");
                }
                list.set(page + 1, itemIn);
                list.set(page + 2, air);
            } else {
                if (debug) {
                    Skript.error((String)"itemIn: add");
                }
                list.add(itemIn);
                list.add(air);
            }
        } else if (mode == "set") {
            if (debug) {
                Skript.error((String)"item1: set");
            }
            list.set(page + 1, item1);
            list.set(page + 2, item2);
        } else {
            if (debug) {
                Skript.error((String)"item2: add");
            }
            list.add(item1);
            list.add(item2);
        }
        Traders.replace(trader, list);
        main.saveTraders(false);
    }

    public static void TraderListPages(String trader, Player player) {
        if (!Trader.validTrader(trader)) {
            return;
        }
        List list = (List)Traders.get(trader);
        int pages = Trader.getPages(list);
        String ShowItem2 = "empty";
        String ShowItem1 = "empty";
        String ShowItem0 = "empty";
        player.sendMessage(ChatColor.GOLD + "Trader " + trader.toLowerCase() + "'s items");
        player.sendMessage(ChatColor.GRAY + "There are " + pages + " page(s):");
        int i = 0;
        while (i < pages) {
            int page = i * 3;
            ItemStack item0 = (ItemStack)list.get(page);
            ItemStack item1 = (ItemStack)list.get(page + 1);
            ItemStack item2 = (ItemStack)list.get(page + 2);
            if (Trader.isValidMaterial(item0, false)) {
                ShowItem0 = item0.getType().toString().toLowerCase();
            }
            if (Trader.isValidMaterial(item1, false)) {
                ShowItem1 = item1.getType().toString().toLowerCase();
            }
            if (Trader.isValidMaterial(item2, true)) {
                ShowItem2 = item2.getType().toString().toLowerCase();
            }
            player.sendMessage(ChatColor.YELLOW + i + ": " + ShowItem0 + ", " + ShowItem1 + " and " + ShowItem2);
            ++i;
        }
    }

    public static void TraderOpen(String trader, Player player) {
        Merchant merchant;
        if (!Trader.validTrader(trader)) {
            return;
        }
        List list = (List)Traders.get(trader);
        if (list.size() == 0) {
            return;
        }
        int pages = Trader.getPages(list);
        if (debug) {
            Skript.error((String)(pages + " | " + list.size()));
        }
        MerchantAPI api = Merchants.get();
        try {
            merchant = api.newMerchant(trader);
            merchant.setTitle(trader);
        }
        catch (NullPointerException e) {
            Skript.error((String)"Could not open merchant as the api is not enabled.");
            e.printStackTrace();
            return;
        }
        int i = 0;
        while (i < pages) {
            ItemStack item2;
            int page = i * 3;
            ItemStack item0 = (ItemStack)list.get(page);
            ItemStack item1 = (ItemStack)list.get(page + 1);
            try {
                item2 = (ItemStack)list.get(page + 2);
            }
            catch (IndexOutOfBoundsException e) {
                item2 = null;
            }
            if (item2.getType().equals((Object)Material.getMaterial((String)"AIR"))) {
                item2 = null;
            }
            if (Trader.isValidMaterial(item2, true)) {
                merchant.addOffer(api.newOffer(item0, item1, item2));
            } else if (Trader.isValidMaterial(item0, false) && Trader.isValidMaterial(item1, false)) {
                merchant.addOffer(api.newOffer(item0, item1));
            } else {
                Skript.error((String)"Could not add offer as the item either was illegal or does not exist.", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            }
            ++i;
        }
        merchant.addCustomer(player);
    }

    private static boolean isValidMaterial(ItemStack item, boolean canBeNull) {
        if (item != null) {
            if (item.getTypeId() == 115 || item.getTypeId() == 36 || item.getType().equals((Object)Material.getMaterial((String)"DOUBLE_STONE_SLAB")) || item.getType().equals((Object)Material.getMaterial((String)"REDSTONE_COMPARATOR_ON")) || item.getType().equals((Object)Material.getMaterial((String)"REDSTONE_COMPARATOR_OFF")) || item.getType().equals((Object)Material.getMaterial((String)"FLOWER_POT")) || item.getType().equals((Object)Material.getMaterial((String)"TRIPWIRE")) || item.getType().equals((Object)Material.getMaterial((String)"REDSTONE_LAMP_ON")) || item.getType().equals((Object)Material.getMaterial((String)"POTATO")) || item.getType().equals((Object)Material.getMaterial((String)"CARROT")) || item.getType().equals((Object)Material.getMaterial((String)"CAULDRON")) || item.getType().equals((Object)Material.getMaterial((String)"REWING_STAND")) || item.getType().equals((Object)Material.getMaterial((String)"SKULL")) || item.getType().equals((Object)Material.getMaterial((String)"WOODEN_DOOR")) || item.getType().equals((Object)Material.getMaterial((String)"SPRUCE_DOOR")) || item.getType().equals((Object)Material.getMaterial((String)"JUNGLE_DOOR")) || item.getType().equals((Object)Material.getMaterial((String)"DARK_OAK_DOOR")) || item.getType().equals((Object)Material.getMaterial((String)"ACACIA_DOOR")) || item.getType().equals((Object)Material.getMaterial((String)"BIRCH_DOOR")) || item.getType().equals((Object)Material.getMaterial((String)"DIODE_BLOCK_ON")) || item.getType().equals((Object)Material.getMaterial((String)"DIODE_BLOCK_OFF")) || item.getType().equals((Object)Material.getMaterial((String)"CAKE_BLOCK")) || item.getType().equals((Object)Material.getMaterial((String)"SUGAR_CANE_BLOCK")) || item.getType().equals((Object)Material.getMaterial((String)"IRON_DOOR_BLOCK")) || item.getType().equals((Object)Material.getMaterial((String)"SIGN_POST ")) || item.getType().equals((Object)Material.getMaterial((String)"WALL_SIGN")) || item.getType().equals((Object)Material.getMaterial((String)"REDSTONE_WIRE")) || item.getType().equals((Object)Material.getMaterial((String)"COCOA")) || item.getType().equals((Object)Material.getMaterial((String)"AIR")) || item.getType().equals((Object)Material.getMaterial((String)"WATER")) || item.getType().equals((Object)Material.getMaterial((String)"STATIONARY_WATER")) || item.getType().equals((Object)Material.getMaterial((String)"LAVA")) || item.getType().equals((Object)Material.getMaterial((String)"STATIONARY_LAVA")) || item.getType().equals((Object)Material.getMaterial((String)"PORTAL")) || item.getType().equals((Object)Material.getMaterial((String)"ENDER_PORTAL")) || item.getType().equals((Object)Material.getMaterial((String)"PISTON_EXTENSION")) || item.getType().equals((Object)Material.getMaterial((String)"PISTON_MOVING_PIECE")) || item.getType().equals((Object)Material.getMaterial((String)"BED_BLOCK")) || item.getType().equals((Object)Material.getMaterial((String)"MELON_STEM")) || item.getType().equals((Object)Material.getMaterial((String)"FIRE"))) {
                Skript.error((String)("Illegal material for one of the items '" + item.getType() + "'"));
                return false;
            }
            return true;
        }
        return canBeNull;
    }

    private static boolean validTrader(String trader) {
        if (Traders.containsKey(trader)) {
            return true;
        }
        Skript.error((String)("No trader found named " + trader), (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
        return false;
    }

    private static int getPages(List<ItemStack> list) {
        return Math.floorDiv(list.size() + 1, 3);
    }

    public static Map<String, Object> getTrader() {
        return Traders;
    }

    public static void setTrader(Map<String, Object> map) {
        Traders = map;
    }
}

