/*
 * Decompiled with CFR 0.152.
 */
package com.kh498.main;

import ch.njol.skript.Skript;
import com.kh498.main.Register;
import com.kh498.main.trader.Trader;
import java.util.HashMap;
import java.util.Map;
import me.cybermaxke.merchants.api.Merchants;
import me.cybermaxke.merchants.v18r3.SMerchantAPI;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin {
    public void onEnable() {
        Trader Trader2 = new Trader(this);
        if (Bukkit.getPluginManager().getPlugin("Merchants") == null) {
            Merchants.set(new SMerchantAPI());
            this.getLogger().info("Could not find Merchants. Using the default version v1_8_R3");
        } else {
            this.getLogger().info("Found Merchants using the it's version of the API");
        }
        Skript.registerAddon((JavaPlugin)this);
        boolean merchant = false;
        if (Skript.isAcceptRegistrations()) {
            merchant = Register.RegisterMerchants();
            this.loadTraders();
        } else {
            Skript.error((String)"Could not register effects as skript is not accepting registrations.");
        }
        if (merchant) {
            this.getLogger().info("Merchants effects added!");
            this.getLogger().info("Enabled ~ Created by kh498");
        } else {
            this.getLogger().info("Could not enable the plugin!");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    public void onDisable() {
        this.saveTraders(true);
    }

    public void saveTraders(boolean log) {
        Map<String, Object> Traders = Trader.getTrader();
        if (Traders.size() != 0) {
            this.getConfig().createSection("Traders", Traders);
            if (log) {
                this.getLogger().info("Traders saved.");
            }
        } else if (log) {
            this.getLogger().info("Could not save config as there are no traders.");
        }
        this.saveConfig();
    }

    public void loadTraders() {
        this.getConfig();
        try {
            Map map = this.getConfig().getConfigurationSection("Traders").getValues(false);
            Trader.setTrader(map);
            this.getLogger().info("Traders loaded!");
        }
        catch (NullPointerException e) {
            this.getLogger().info("No traders loaded.");
        }
    }

    public Map<String, String> convert(Map<String, Object> map) {
        HashMap<String, String> newMap = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (!(entry.getValue() instanceof String)) continue;
            newMap.put(entry.getKey(), (String)entry.getValue());
        }
        return newMap;
    }
}

