/*
 * Decompiled with CFR 0.152.
 */
package io.github.bi0qaw.vector;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExprVectorNumberArithmetic
extends SimpleExpression<Vector> {
    private Expression<Vector> vector;
    private Expression<Number> number;
    private int parseMark;

    public boolean isSingle() {
        return true;
    }

    public String toString(Event event, boolean b) {
        return "vector number arithmetic";
    }

    public Class<? extends Vector> getReturnType() {
        return Vector.class;
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.parseMark = parseResult.mark;
        switch (this.parseMark) {
            case 1: 
            case 2: {
                this.vector = expressions[0];
                this.number = expressions[1];
                break;
            }
            case 3: {
                this.number = expressions[0];
                this.vector = expressions[1];
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return true;
    }

    public Vector[] get(Event event) {
        Vector v = (Vector)this.vector.getSingle(event);
        Number n = (Number)this.number.getSingle(event);
        if (v == null || n == null) {
            return null;
        }
        switch (this.parseMark) {
            case 1: 
            case 3: {
                return new Vector[]{v.clone().multiply(n.doubleValue())};
            }
            case 2: {
                return new Vector[]{v.clone().multiply(1.0 / n.doubleValue())};
            }
        }
        assert (false);
        return null;
    }
}

