/*
 * Decompiled with CFR 0.152.
 */
package io.github.bi0qaw.vector;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.Patterns;
import ch.njol.util.Kleenean;
import java.lang.reflect.Array;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExprArithmetic
extends SimpleExpression<Vector> {
    protected static final Patterns<Operator> patterns = new Patterns((Object[][])new Object[][]{{"%vector%[ ]++[ ]%vector%", Operator.PLUS}, {"%vector%[ ]--[ ]%vector%", Operator.MINUS}, {"%vector%[ ]**[ ]%vector%", Operator.MULT}, {"%vector%[ ]//[ ]%vector%", Operator.DIV}});
    private Expression<Vector> first;
    private Expression<Vector> second;
    private Operator op;

    protected Vector[] get(Event event) {
        Vector[] vectors = (Vector[])Array.newInstance(Vector.class, 1);
        Vector v1 = (Vector)this.first.getSingle(event);
        Vector v2 = (Vector)this.second.getSingle(event);
        if (v1 == null) {
            v1 = new Vector();
        }
        if (v2 == null) {
            v2 = new Vector();
        }
        vectors[0] = this.op.calculate(v1, v2);
        return vectors;
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Vector> getReturnType() {
        return Vector.class;
    }

    public String toString(Event event, boolean b) {
        return this.first.toString(event, b) + " " + (Object)((Object)this.op) + " " + this.second.toString(event, b);
    }

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.first = expressions[0];
        this.second = expressions[1];
        this.op = (Operator)((Object)patterns.getInfo(matchedPattern));
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Operator {
        PLUS("++"){

            public Vector calculate(Vector v1, Vector v2) {
                return v1.clone().add(v2);
            }
        }
        ,
        MINUS("--"){

            public Vector calculate(Vector v1, Vector v2) {
                return v1.clone().subtract(v2);
            }
        }
        ,
        MULT("**"){

            public Vector calculate(Vector v1, Vector v2) {
                return v1.clone().multiply(v2);
            }
        }
        ,
        DIV("//"){

            public Vector calculate(Vector v1, Vector v2) {
                return v1.clone().divide(v2);
            }
        };

        public final String sign;

        private Operator(String sign) {
            this.sign = sign;
        }

        public abstract Vector calculate(Vector var1, Vector var2);

        public String toString() {
            return this.sign;
        }
    }
}

