/*
 * Decompiled with CFR 0.152.
 */
package io.github.bi0qaw.util;

import org.bukkit.util.Vector;

public class Matrix3 {
    private double[] m = new double[9];

    public Matrix3(double[] d) {
        for (int i = 0; i < 9; ++i) {
            this.m[i] = d[i];
        }
    }

    public Matrix3(Vector u, Vector v, Vector w) {
        this.m[0] = u.getX();
        this.m[1] = u.getY();
        this.m[2] = u.getZ();
        this.m[3] = v.getX();
        this.m[4] = v.getY();
        this.m[5] = v.getZ();
        this.m[6] = w.getX();
        this.m[7] = w.getY();
        this.m[8] = w.getZ();
    }

    public double det() {
        return this.m[0] * this.m[4] * this.m[8] + this.m[1] * this.m[5] * this.m[6] + this.m[2] * this.m[3] * this.m[7] - this.m[2] * this.m[4] * this.m[6] - this.m[0] * this.m[5] * this.m[7] - this.m[1] * this.m[3] * this.m[8];
    }

    public void invert() {
        Double det = this.det();
        if (det.equals(0)) {
            return;
        }
        double invdet = 1.0 / det;
        double[] d = new double[]{(this.m[4] * this.m[8] - this.m[5] * this.m[7]) * invdet, (this.m[2] * this.m[7] - this.m[8] * this.m[1]) * invdet, (this.m[1] * this.m[5] - this.m[2] * this.m[4]) * invdet, (this.m[5] * this.m[6] - this.m[3] * this.m[8]) * invdet, (this.m[0] * this.m[8] - this.m[2] * this.m[6]) * invdet, (this.m[2] * this.m[3] - this.m[0] * this.m[5]) * invdet, (this.m[3] * this.m[7] - this.m[4] * this.m[6]) * invdet, (this.m[1] * this.m[6] - this.m[0] * this.m[7]) * invdet, (this.m[0] * this.m[4] - this.m[1] * this.m[3]) * invdet};
        for (int i = 0; i < 9; ++i) {
            this.m[i] = d[i];
        }
    }

    public Vector mul(Vector v) {
        double x = v.getX();
        double y = v.getY();
        double z = v.getZ();
        return new Vector(this.m[0] * x + this.m[1] * y + this.m[2] * z, this.m[3] * x + this.m[4] * y + this.m[5] * z, this.m[6] * x + this.m[7] * y + this.m[8] * z);
    }
}

