/*
 * Decompiled with CFR 0.152.
 */
package io.github.bi0qaw.tortoise;

import io.github.bi0qaw.tortoise.Tortoise;
import io.github.bi0qaw.tortoise.Turtle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TurtleManager {
    private static final HashMap<UUID, Turtle> turtles = new HashMap();

    public static void register(Turtle turtle) {
        turtles.put(turtle.getId(), turtle);
    }

    public static void remove(Turtle turtle) {
        turtles.remove(turtle.getId());
    }

    public static void release(Turtle turtle) {
        if (!turtle.isFree() && turtle.getHeartbeat() > 0) {
            turtle.setIsFree(true);
            int task = Bukkit.getServer().getScheduler().runTaskTimer((Plugin)Tortoise.getPlugin(), (Runnable)turtle, 0L, (long)turtle.getHeartbeat()).getTaskId();
            turtle.setTask(task);
        }
    }

    public static void stop(Turtle turtle) {
        if (turtle.isFree() && turtle.getTask() != -1) {
            Bukkit.getScheduler().cancelTask(turtle.getTask());
        }
    }

    public static boolean isRegistered(UUID id) {
        return turtles.containsKey(id);
    }

    public static ArrayList<Turtle> getAll() {
        ArrayList<Turtle> t = new ArrayList<Turtle>();
        t.addAll(turtles.values());
        return t;
    }

    public static Turtle getTurtle(UUID id) {
        if (turtles.containsKey(id)) {
            return turtles.get(id);
        }
        return null;
    }
}

