/*
 * Decompiled with CFR 0.152.
 */
package io.github.bi0qaw.tortoise;

import ch.njol.skript.lang.function.Function;
import io.github.bi0qaw.tortoise.TurtleManager;
import io.github.bi0qaw.tortoise.util.Matrix3;
import io.github.bi0qaw.tortoise.util.VectorMath;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Turtle
implements Runnable,
Cloneable {
    private final UUID id = UUID.randomUUID();
    private Vector position = new Vector(0, 0, 0);
    private Vector u = new Vector(1, 0, 0);
    private Vector v = new Vector(0, 1, 0);
    private Vector w = new Vector(0, 0, 1);
    private Matrix3 inverseMatrix = new Matrix3(this.u, this.v, this.w);
    private boolean matrixIsDirty = false;
    private World world;
    private String name;
    private boolean isFree = false;
    private int heartbeat = 1;
    private int task = -1;
    private boolean followRotation = false;
    private Turtle parent;
    private ArrayList<Turtle> children = new ArrayList();
    private Function<?> function;
    private Object[][] parameters;
    private static final Vector V_ZERO = new Vector();

    public Turtle(Location l) {
        TurtleManager.register(this);
        this.setLocation(l);
    }

    public void setLocation(Location location) {
        Vector l1 = location.toVector();
        Vector delta = l1.subtract(this.getPosition());
        this.position = this.position.add(delta);
        this.setWorld(location.getWorld());
    }

    public Location getLocation() {
        Vector p = this.getPosition();
        return new Location(this.getWorld(), p.getX(), p.getY(), p.getZ(), 0.0f, 0.0f);
    }

    public void rotate(Vector axis, double angle) {
        this.u = VectorMath.rot(this.getU(), axis, angle);
        this.v = VectorMath.rot(this.getV(), axis, angle);
        this.w = VectorMath.rot(this.getW(), axis, angle);
        this.matrixIsDirty = true;
        if (!this.children.isEmpty()) {
            for (Turtle c : this.children) {
                if (!c.isFollowRotation()) continue;
                c.rotate(axis, angle);
            }
        }
    }

    public void rotateU(double u) {
        this.v = VectorMath.rot(this.getV(), this.getU(), u);
        this.w = VectorMath.rot(this.getW(), this.getU(), u);
        this.matrixIsDirty = true;
        if (!this.children.isEmpty()) {
            for (Turtle c : this.children) {
                if (!c.isFollowRotation()) continue;
                c.rotateU(u);
            }
        }
    }

    public void rotateV(double v) {
        this.u = VectorMath.rot(this.getU(), this.getV(), v);
        this.w = VectorMath.rot(this.getW(), this.getV(), v);
        this.matrixIsDirty = true;
        if (!this.children.isEmpty()) {
            for (Turtle c : this.children) {
                if (!c.isFollowRotation()) continue;
                c.rotateV(v);
            }
        }
    }

    public void rotateW(double w) {
        this.u = VectorMath.rot(this.getU(), this.getW(), w);
        this.v = VectorMath.rot(this.getV(), this.getW(), w);
        this.matrixIsDirty = true;
        if (!this.children.isEmpty()) {
            for (Turtle c : this.children) {
                if (!c.isFollowRotation()) continue;
                c.rotateW(w);
            }
        }
    }

    public double getYaw() {
        Float pitch = Float.valueOf((float)this.getPitch());
        if (pitch.equals(Float.valueOf(1.5707964f)) || pitch.equals(Float.valueOf(-1.5707964f))) {
            return 0.0;
        }
        return Math.atan2(this.w.getX(), this.u.getX());
    }

    public double getPitch() {
        return Math.atan2(-this.w.getY(), Math.sqrt(this.u.getX() * this.u.getX() + this.w.getX() * this.w.getX()));
    }

    public double getRoll() {
        Float pitch = Float.valueOf((float)this.getPitch());
        if (pitch.equals(Float.valueOf(1.5707964f))) {
            return Math.atan2(this.u.getZ(), this.w.getZ());
        }
        if (pitch.equals(Float.valueOf(-1.5707964f))) {
            return -Math.atan2(this.u.getZ(), this.w.getZ());
        }
        return Math.atan2(this.v.getZ(), this.v.getY());
    }

    public void resetRotation() {
        this.u.setX(1).setY(0).setZ(0);
        this.v.setX(0).setY(1).setZ(0);
        this.w.setX(0).setY(0).setZ(1);
        this.matrixIsDirty = true;
        if (!this.children.isEmpty()) {
            for (Turtle c : this.children) {
                if (!c.isFollowRotation()) continue;
                c.resetRotation();
            }
        }
    }

    public void move(double u, double v, double w) {
        this.moveU(u);
        this.moveV(v);
        this.moveW(w);
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public Function<?> getFunction() {
        return this.function;
    }

    public void setFunction(Function<?> function) {
        this.function = function;
    }

    public Object[][] getParameters() {
        return this.parameters;
    }

    public void setParameters(Object[][] parameters) {
        this.parameters = parameters;
    }

    public boolean isFollowRotation() {
        return this.followRotation;
    }

    public void setFollowRotation(boolean followRotation) {
        this.followRotation = followRotation;
    }

    public Vector getU() {
        return this.u.clone();
    }

    public Vector getV() {
        return this.v.clone();
    }

    public Vector getW() {
        return this.w.clone();
    }

    public void moveU(double n) {
        this.position.add(this.getU().multiply(n));
    }

    public void moveV(double n) {
        this.position.add(this.getV().multiply(n));
    }

    public void moveW(double n) {
        this.position.add(this.getW().multiply(n));
    }

    public void setU(Vector u) {
        if (!u.equals((Object)V_ZERO)) {
            Vector future = u.clone().normalize();
            if (future.equals((Object)this.u)) {
                return;
            }
            Vector axis = this.getU().getCrossProduct(future);
            double angle = (double)this.getU().angle(future) * 57.29577951308232;
            this.u = future;
            this.v = VectorMath.rot(this.v, axis, angle);
            this.w = VectorMath.rot(this.w, axis, angle);
        }
    }

    public void setV(Vector v) {
        if (!v.equals((Object)V_ZERO)) {
            Vector future = v.clone().normalize();
            if (future.equals((Object)this.v)) {
                return;
            }
            Vector axis = this.getV().getCrossProduct(future);
            double angle = (double)this.getV().angle(future) * 57.29577951308232;
            this.v = future;
            this.u = VectorMath.rot(this.u, axis, angle);
            this.w = VectorMath.rot(this.w, axis, angle);
        }
    }

    public void setW(Vector w) {
        if (!w.equals((Object)V_ZERO)) {
            Vector future = w.clone().normalize();
            if (future.equals((Object)this.w)) {
                return;
            }
            Vector axis = this.getW().getCrossProduct(future);
            double angle = (double)this.getW().angle(future) * 57.29577951308232;
            this.w = future;
            this.u = VectorMath.rot(this.u, axis, angle);
            this.v = VectorMath.rot(this.v, axis, angle);
        }
    }

    public boolean isFree() {
        return this.isFree;
    }

    protected void setIsFree(boolean b) {
        this.isFree = b;
    }

    public int getHeartbeat() {
        return this.heartbeat;
    }

    public void setHeartbeat(int heartbeat) {
        this.heartbeat = heartbeat == 0 ? 1 : heartbeat;
    }

    public int getTask() {
        return this.task;
    }

    protected void setTask(int task) {
        this.task = task;
    }

    public Vector getPosition() {
        if (this.hasParent()) {
            return this.parent.getPosition(this.position);
        }
        return this.position;
    }

    public Vector getPosition(Vector d) {
        return this.getPosition(d.getX(), d.getY(), d.getZ());
    }

    public Vector getPosition(double u, double v, double w) {
        Vector p = this.getPosition().clone();
        p.add(this.getU().multiply(u));
        p.add(this.getV().multiply(v));
        p.add(this.getW().multiply(w));
        return p;
    }

    public void setPosition(Vector position) {
        this.position = position;
    }

    public ArrayList<Turtle> getChildren() {
        return this.children;
    }

    private void addChild(Turtle turtle) {
        turtle.setParent(this);
    }

    public boolean hasChild(Turtle child) {
        for (Turtle t : this.getChildren()) {
            if (!t.equals(child)) continue;
            return true;
        }
        return false;
    }

    public boolean hasDescendant(Turtle descendant) {
        for (Turtle t : this.getDescendants()) {
            if (!t.equals(descendant)) continue;
            return true;
        }
        return false;
    }

    public ArrayList<Turtle> getDescendants() {
        ArrayList<Turtle> descendants = new ArrayList<Turtle>();
        if (!this.children.isEmpty()) {
            for (Turtle c : this.children) {
                descendants.add(c);
                descendants.addAll(c.getDescendants());
            }
        }
        return descendants;
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Turtle getParent() {
        return this.parent;
    }

    public void setParent(Turtle parent) {
        if (parent.getDescendants().contains(this) || this.getDescendants().contains(parent)) {
            return;
        }
        Vector currentPos = this.getPosition();
        Vector parentPos = parent.getPosition();
        parent.updateMatrix();
        this.position = parent.getInverseMatrix().mul(currentPos.subtract(parentPos));
        if (this.isFollowRotation()) {
            this.u = parent.getU();
            this.v = parent.getV();
            this.w = parent.getW();
            this.matrixIsDirty = true;
        }
        if (this.hasParent()) {
            this.getParent().children.remove(this);
        }
        parent.children.add(this);
        this.parent = parent;
        if (!this.children.isEmpty()) {
            for (Turtle t : this.children) {
                t.setParent(this);
            }
        }
    }

    public void removeParent() {
        this.position = this.getPosition();
        this.parent = null;
    }

    public World getWorld() {
        return this.world;
    }

    public void teleport(Location location) {
        this.setLocation(location);
    }

    public void setWorld(World world) {
        this.world = world;
    }

    public Matrix3 getInverseMatrix() {
        return this.inverseMatrix;
    }

    public boolean isMatrixIsDirty() {
        return this.matrixIsDirty;
    }

    public void setMatrixIsDirty(boolean matrixIsDirty) {
        this.matrixIsDirty = matrixIsDirty;
    }

    public void updateMatrix() {
        if (this.isMatrixIsDirty()) {
            this.inverseMatrix = new Matrix3(this.getU(), this.getV(), this.getW());
            this.inverseMatrix.invert();
            this.setMatrixIsDirty(false);
        }
    }

    public void remove() {
        this.stop();
        TurtleManager.remove(this);
    }

    public void removeWithChildren() {
        this.stopWithChildren();
        TurtleManager.remove(this);
        for (Turtle t : this.getChildren()) {
            t.remove();
        }
    }

    public void removeWithDescendants() {
        this.stopWithDescendants();
        TurtleManager.remove(this);
        for (Turtle t : this.getDescendants()) {
            t.remove();
        }
    }

    public void release() {
        if (!this.isFree) {
            TurtleManager.release(this);
            this.isFree = true;
        }
    }

    public void releaseWithChildren() {
        this.release();
        for (Turtle t : this.getChildren()) {
            t.release();
        }
    }

    public void releaseWithDescendants() {
        this.release();
        for (Turtle t : this.getDescendants()) {
            t.release();
        }
    }

    public void stop() {
        if (this.isFree) {
            TurtleManager.stop(this);
            this.isFree = false;
        }
    }

    public void stopWithChildren() {
        this.stop();
        for (Turtle t : this.getChildren()) {
            t.stop();
        }
    }

    public void stopWithDescendants() {
        this.stop();
        for (Turtle t : this.getDescendants()) {
            t.stopWithDescendants();
        }
    }

    @Override
    public void run() {
        if (this.function != null) {
            this.function.execute(this.parameters);
        }
    }

    public Turtle clone() {
        Turtle turtle = new Turtle(this.getLocation());
        turtle.u = this.getU();
        turtle.v = this.getV();
        turtle.w = this.getW();
        if (this.hasParent()) {
            turtle.setParent(this.getParent());
        }
        for (Turtle c : this.getChildren()) {
            turtle.addChild(c);
        }
        turtle.matrixIsDirty = true;
        turtle.name = new String(this.getName());
        turtle.heartbeat = this.getHeartbeat();
        turtle.followRotation = this.isFollowRotation();
        return turtle;
    }
}

