/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.ticker.tasks;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import me.limeglass.ticker.Ticker;
import me.limeglass.ticker.objects.events.AverageTpsChangeEvent;
import me.limeglass.ticker.objects.events.TpsChangeEvent;
import me.limeglass.ticker.utils.ReflectionUtil;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.event.Event;

public class TpsHandler
implements Runnable {
    private long millseconds = 0L;
    private static double lastTps;
    private static double tps;
    private static double lastAverageTps;
    public static Map<Long, Double> tpsMap;

    static {
        tpsMap = new HashMap<Long, Double>();
    }

    public static double getAverageTps() {
        double tpsSum = 0.0;
        for (Map.Entry<Long, Double> pastTps : tpsMap.entrySet()) {
            tpsSum += pastTps.getValue().doubleValue();
        }
        return (double)Math.round(tpsSum / (double)tpsMap.entrySet().size() * 100.0) / 100.0;
    }

    public static String getStringAverageTps() {
        ChatColor colour = ChatColor.GREEN;
        if (TpsHandler.getAverageTps() > 13.0 && TpsHandler.getAverageTps() < 17.0) {
            colour = ChatColor.GOLD;
        }
        if (TpsHandler.getAverageTps() < 13.0) {
            colour = ChatColor.RED;
        }
        return colour + String.valueOf(TpsHandler.getAverageTps());
    }

    public static double getLastTps() {
        if (tpsMap.isEmpty()) {
            return 0.0;
        }
        return lastTps;
    }

    public static double getTps() {
        if (tpsMap.isEmpty()) {
            return 0.0;
        }
        return tps;
    }

    public static double getTpsNear(long timestamp) {
        double tps = 0.0;
        for (Map.Entry<Long, Double> entry : tpsMap.entrySet()) {
            long calculate = timestamp - entry.getKey();
            if (calculate < 0L || calculate >= 2000L) continue;
            tps = entry.getValue();
        }
        return tps;
    }

    public static String getBukkitTps() {
        try {
            Class<?> minecraftServer = ReflectionUtil.getNMSClass("MinecraftServer");
            Object server = minecraftServer.getMethod("getServer", new Class[0]).invoke(null, new Object[0]);
            Field field = server.getClass().getField("recentTps");
            DecimalFormat format = new DecimalFormat("##.##");
            double[] tps = null;
            tps = (double[])field.get(server);
            String ftps = "";
            ftps = Double.compare(tps[0], 20.0) > 0 ? String.valueOf(20.0) : format.format(tps[0]);
            return ftps;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            Ticker.consoleMessage("The recentTps field doesn't exist for your version. Please refrain from using the Bukkit tps expression.");
            exception.printStackTrace();
            return null;
        }
    }

    public static String getStringTps() {
        ChatColor colour = ChatColor.GREEN;
        if (TpsHandler.getTps() > 13.0 && TpsHandler.getTps() < 17.0) {
            colour = ChatColor.GOLD;
        }
        if (TpsHandler.getTps() < 13.0) {
            colour = ChatColor.RED;
        }
        return colour + String.valueOf(TpsHandler.getTps());
    }

    @Override
    public void run() {
        if (this.millseconds > 0L) {
            double diff = (double)(System.currentTimeMillis() - this.millseconds) - 1000.0;
            if (diff < 0.0) {
                diff = Math.abs(diff);
            }
            if ((tps = diff == 0.0 ? 20.0 : 20.0 - diff / 50.0) < 0.0) {
                tps = 0.0;
            }
            if (!tpsMap.isEmpty()) {
                if (lastTps != tps) {
                    Bukkit.getPluginManager().callEvent((Event)new TpsChangeEvent(lastTps, tps));
                }
                if (lastAverageTps != TpsHandler.getAverageTps()) {
                    Bukkit.getPluginManager().callEvent((Event)new AverageTpsChangeEvent(lastAverageTps, TpsHandler.getAverageTps()));
                }
            }
            lastAverageTps = TpsHandler.getAverageTps();
            tpsMap.put(System.currentTimeMillis(), tps);
            lastTps = tps;
        }
        this.millseconds = System.currentTimeMillis();
    }
}

