/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.ticker;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import me.limeglass.ticker.Metrics;
import me.limeglass.ticker.elements.Register;
import me.limeglass.ticker.tasks.TpsHandler;
import me.limeglass.ticker.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Ticker
extends JavaPlugin {
    public FileConfiguration config = this.getConfig();
    public static File syntaxFile;
    private Metrics metrics;
    private SkriptAddon addonInstance;
    private final int interval = 20;
    private static Ticker instance;
    private static FileConfiguration syntaxData;
    private static String packageName;
    private static String prefix;
    private static String nameplate;

    static {
        packageName = "me.limeglass.ticker";
        prefix = "&8[&eTicker&8] &6";
        nameplate = "[Ticker] ";
    }

    public void onEnable() {
        this.addonInstance = Skript.registerAddon((JavaPlugin)this).setLanguageFileDirectory("lang");
        instance = this;
        long time = this.config.getBoolean("ServerStartupQueue", true) ? 130L : 1L;
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)instance, (Runnable)new TpsHandler(), time, 20L);
        File file = new File(this.getDataFolder(), "config.yml");
        syntaxFile = new File(this.getDataFolder(), "Syntax.yml");
        if (!Objects.equals(this.getDescription().getVersion(), this.config.getString("version"))) {
            Ticker.consoleMessage("New update found! Updating files now...");
            if (file.exists()) {
                file.delete();
            }
        }
        for (File f : Arrays.asList(file, syntaxFile)) {
            if (f.exists()) continue;
            f.getParentFile().mkdirs();
            this.saveResource(f.getName(), false);
        }
        syntaxData = new YamlConfiguration();
        try {
            syntaxData.load(syntaxFile);
            this.addonInstance.loadClasses(Ticker.getPackageName(), new String[]{"elements"});
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
        this.metrics = new Metrics(this);
        Register.metrics(this.metrics);
        new Register();
        if (!this.config.getBoolean("DisableRegisteredInfo", false)) {
            Bukkit.getLogger().info(String.valueOf(nameplate) + "has been enabled!");
        }
    }

    public static Ticker getInstance() {
        return instance;
    }

    public SkriptAddon getAddonInstance() {
        return this.addonInstance;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public static String getPackageName() {
        return packageName;
    }

    public static String getNameplate() {
        return nameplate;
    }

    public static String getPrefix() {
        return prefix;
    }

    public static FileConfiguration getSyntaxData() {
        return syntaxData;
    }

    public static void debugMessage(String text) {
        if (instance.getConfig().getBoolean("debug")) {
            Ticker.consoleMessage("&b" + text);
        }
    }

    public static void consoleMessage(String ... messages) {
        String[] stringArray = messages;
        int n = messages.length;
        int n2 = 0;
        while (n2 < n) {
            String text = stringArray[n2];
            Bukkit.getConsoleSender().sendMessage(Utils.cc(String.valueOf(prefix) + text));
            ++n2;
        }
    }
}

