/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.ticker;

import ch.njol.skript.doc.Description;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.util.SimpleEvent;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import me.limeglass.ticker.Ticker;
import me.limeglass.ticker.utils.Utils;
import me.limeglass.ticker.utils.annotations.AllChangers;
import me.limeglass.ticker.utils.annotations.AntiDependency;
import me.limeglass.ticker.utils.annotations.Changers;
import me.limeglass.ticker.utils.annotations.Disabled;
import org.bukkit.Bukkit;

public class Syntax {
    private static HashMap<String, String[]> modified = new HashMap();
    private static HashMap<String, String[]> completeSyntax = new HashMap();

    public static String[] register(Class<?> syntaxClass, String ... syntax) {
        if (syntaxClass.isAnnotationPresent(Disabled.class)) {
            return null;
        }
        String type = "Expressions";
        if (Condition.class.isAssignableFrom(syntaxClass)) {
            type = "Conditions";
        } else if (Effect.class.isAssignableFrom(syntaxClass)) {
            type = "Effects";
        } else if (SimpleEvent.class.isAssignableFrom(syntaxClass)) {
            type = "Events";
        } else if (PropertyExpression.class.isAssignableFrom(syntaxClass)) {
            type = "PropertyExpressions";
        }
        String node = "Syntax." + type + "." + syntaxClass.getSimpleName() + ".";
        if (!Ticker.getSyntaxData().isSet(String.valueOf(node) + "enabled")) {
            Ticker.getSyntaxData().set(String.valueOf(node) + "enabled", (Object)true);
            Syntax.save();
        }
        if (syntaxClass.isAnnotationPresent(Changers.class) || syntaxClass.isAnnotationPresent(AllChangers.class)) {
            if (syntaxClass.isAnnotationPresent(AllChangers.class)) {
                Ticker.getSyntaxData().set(String.valueOf(node) + "changers", (Object)"All changers");
            } else {
                Object[] changers = syntaxClass.getAnnotation(Changers.class).value();
                Ticker.getSyntaxData().set(String.valueOf(node) + "changers", (Object)Arrays.toString(changers));
            }
            Syntax.save();
        }
        if (syntaxClass.isAnnotationPresent(AntiDependency.class)) {
            String plugin = syntaxClass.getAnnotation(AntiDependency.class).value()[0];
            if (Bukkit.getPluginManager().getPlugin(plugin) != null && Bukkit.getPluginManager().getPlugin(plugin).isEnabled()) {
                return null;
            }
        }
        if (syntaxClass.isAnnotationPresent(Description.class)) {
            String[] descriptions = syntaxClass.getAnnotation(Description.class).value();
            Ticker.getSyntaxData().set(String.valueOf(node) + "description", (Object)descriptions[0]);
            Syntax.save();
        }
        if (!Ticker.getSyntaxData().getBoolean(String.valueOf(node) + "enabled")) {
            if (Ticker.getInstance().getConfig().getBoolean("NotRegisteredSyntax", false)) {
                Ticker.consoleMessage(String.valueOf(node.toString()) + " didn't register!");
            }
            return null;
        }
        if (!Ticker.getSyntaxData().isSet(String.valueOf(node) + "syntax")) {
            Ticker.getSyntaxData().set(String.valueOf(node) + "syntax", (Object)syntax);
            Syntax.save();
            return Syntax.add(syntaxClass.getSimpleName(), syntax);
        }
        List data = Ticker.getSyntaxData().getStringList(String.valueOf(node) + "syntax");
        if (!Utils.compareArrays(data.toArray(new String[data.size()]), syntax)) {
            modified.put(syntaxClass.getSimpleName(), syntax);
        }
        if (Ticker.getSyntaxData().isList(String.valueOf(node) + "syntax")) {
            List syntaxes = Ticker.getSyntaxData().getStringList(String.valueOf(node) + "syntax");
            return Syntax.add(syntaxClass.getSimpleName(), syntaxes.toArray(new String[syntaxes.size()]));
        }
        return Syntax.add(syntaxClass.getSimpleName(), Ticker.getSyntaxData().getString(String.valueOf(node) + "syntax"));
    }

    public static Boolean isModified(Class syntaxClass) {
        return modified.containsKey(syntaxClass.getSimpleName());
    }

    public static String[] get(String syntaxClass) {
        return completeSyntax.get(syntaxClass);
    }

    private static String[] add(String syntaxClass, String ... syntax) {
        if (!completeSyntax.containsValue(syntax)) {
            completeSyntax.put(syntaxClass, syntax);
        }
        return syntax;
    }

    public static void save() {
        try {
            Ticker.getSyntaxData().save(Ticker.syntaxFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

