/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.thatpacketaddon.util;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import us.tlatoani.thatpacketaddon.PacketManager;
import us.tlatoani.thatpacketaddon.util.BukkitPacketEvent;

public class SkriptPacketEventListener {
    private final ListenerPriority priority;
    private Set<PacketType> packetTypesListenedFor = new HashSet<PacketType>();
    private static final Map<ListenerPriority, SkriptPacketEventListener> listeners = new HashMap<ListenerPriority, SkriptPacketEventListener>();

    public static void addPacketTypes(PacketType[] packetTypes, ListenerPriority priority) {
        SkriptPacketEventListener listener = listeners.computeIfAbsent(priority, SkriptPacketEventListener::new);
        listener.addPacketTypes(packetTypes);
    }

    private SkriptPacketEventListener(ListenerPriority priority) {
        this.priority = priority;
    }

    private void addPacketTypes(PacketType[] packetTypes) {
        ArrayList<PacketType> packetTypesToStartListeningFor = new ArrayList<PacketType>();
        for (int i = 0; i < packetTypes.length; ++i) {
            if (this.packetTypesListenedFor.contains(packetTypes[i])) continue;
            this.packetTypesListenedFor.add(packetTypes[i]);
            packetTypesToStartListeningFor.add(packetTypes[i]);
        }
        if (!packetTypesToStartListeningFor.isEmpty()) {
            PacketManager.onPacketEvent(packetTypesToStartListeningFor.toArray(new PacketType[0]), this.priority, packetEvent -> {
                BukkitPacketEvent event = new BukkitPacketEvent((PacketEvent)packetEvent, this.priority);
                Bukkit.getServer().getPluginManager().callEvent((Event)event);
            });
        }
    }
}

