/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.thatpacketaddon.util;

import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.reflect.StructureModifier;
import java.util.function.Function;

public abstract class PacketField<T> {
    public final String name;
    public final Class<T> type;
    public final Class<?> singleType;
    public final boolean isSingle;

    protected PacketField(String name, Class<T> type) {
        this.name = name;
        this.type = type;
        if (type == null) {
            this.singleType = null;
            this.isSingle = true;
        } else if (type.isArray()) {
            this.singleType = type.getComponentType();
            this.isSingle = false;
        } else {
            this.singleType = type;
            this.isSingle = true;
        }
    }

    public abstract T get(PacketContainer var1, int var2);

    public abstract void set(PacketContainer var1, int var2, T var3);

    public static <T> PacketField<T> simple(String name, Class<T> type, Function<PacketContainer, StructureModifier<T>> function) {
        return new SimplePacketField<T>(name, type, function);
    }

    public static <F, T> PacketField<T> converted(String name, Class<T> type, Function<PacketContainer, StructureModifier<F>> function, Function<? super F, ? extends T> get, Function<? super T, ? extends F> set) {
        return new ConvertedPacketField(name, type, function, get, set);
    }

    private static class ConvertedPacketField<F, T>
    extends PacketField<T> {
        private final Function<PacketContainer, StructureModifier<F>> function;
        private final Function<? super F, ? extends T> get;
        private final Function<? super T, ? extends F> set;

        private ConvertedPacketField(String name, Class<T> type, Function<PacketContainer, StructureModifier<F>> function, Function<? super F, ? extends T> get, Function<? super T, ? extends F> set) {
            super(name, type);
            this.function = function;
            this.get = get;
            this.set = set;
        }

        @Override
        public T get(PacketContainer packet, int index) {
            Object raw = this.function.apply(packet).readSafely(index);
            if (raw == null) {
                return null;
            }
            return this.get.apply(raw);
        }

        @Override
        public void set(PacketContainer packet, int index, T value) {
            Object raw = value == null ? null : this.set.apply((T)value);
            this.function.apply(packet).writeSafely(index, raw);
        }
    }

    private static class SimplePacketField<T>
    extends PacketField<T> {
        private final Function<PacketContainer, StructureModifier<T>> function;

        protected SimplePacketField(String name, Class<T> type, Function<PacketContainer, StructureModifier<T>> function) {
            super(name, type);
            this.function = function;
        }

        @Override
        public T get(PacketContainer packet, int index) {
            return (T)this.function.apply(packet).readSafely(index);
        }

        @Override
        public void set(PacketContainer packet, int index, T value) {
            this.function.apply(packet).writeSafely(index, value);
        }
    }
}

