/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.thatpacketaddon.syntaxes_legacy;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.BlockPosition;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.PlayerInfoData;
import com.comphenix.protocol.wrappers.Vector3F;
import com.comphenix.protocol.wrappers.WrappedBlockData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.comphenix.protocol.wrappers.WrappedServerPing;
import com.comphenix.protocol.wrappers.WrappedWatchableObject;
import com.comphenix.protocol.wrappers.nbt.NbtBase;
import com.comphenix.protocol.wrappers.nbt.NbtCompound;
import com.comphenix.protocol.wrappers.nbt.NbtFactory;
import com.comphenix.protocol.wrappers.nbt.NbtList;
import com.comphenix.protocol.wrappers.nbt.NbtType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.GameMode;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import us.tlatoani.thatpacketaddon.core.base.Logging;
import us.tlatoani.thatpacketaddon.skin.Skin;
import us.tlatoani.thatpacketaddon.syntaxes_legacy.PacketInfoConverter;

public class ExprJSONObjectOfPacket
extends SimpleExpression<JSONObject> {
    private PacketInfoConverter<JSONObject> singleConverter = null;
    private PacketInfoConverter<JSONObject[]> pluralConverter = null;
    private Expression<Number> index;
    private Expression<PacketContainer> packetContainerExpression;
    private boolean isSingle;
    public static Map<String, PacketInfoConverter<JSONObject>> singleConverters = new LinkedHashMap<String, PacketInfoConverter<JSONObject>>();
    public static Map<String, PacketInfoConverter<JSONObject[]>> pluralConverters = new LinkedHashMap<String, PacketInfoConverter<JSONObject[]>>();

    public static JSONObject fromNBTBase(NbtBase nbtBase) {
        if (nbtBase == null) {
            return null;
        }
        JSONObject result = new JSONObject();
        result.put((Object)"name", (Object)nbtBase.getName());
        if (nbtBase.getType() == NbtType.TAG_LIST) {
            result.put((Object)"type", (Object)("list_" + ((NbtList)nbtBase).getElementType().toString().substring(4).toLowerCase()));
        } else {
            result.put((Object)"type", (Object)nbtBase.getType().toString().substring(4).toLowerCase());
        }
        switch (nbtBase.getType()) {
            case TAG_BYTE: 
            case TAG_SHORT: 
            case TAG_INT: 
            case TAG_LONG: 
            case TAG_FLOAT: 
            case TAG_DOUBLE: 
            case TAG_STRING: {
                result.put((Object)"value", nbtBase.getValue());
                return result;
            }
            case TAG_BYTE_ARRAY: {
                JSONArray jsonByteArray = new JSONArray();
                for (byte b : (byte[])nbtBase.getValue()) {
                    jsonByteArray.add((Object)b);
                }
                result.put((Object)"value", (Object)jsonByteArray);
                return result;
            }
            case TAG_INT_ARRAY: {
                JSONArray jsonIntArray = new JSONArray();
                for (int i : (int[])nbtBase.getValue()) {
                    jsonIntArray.add((Object)i);
                }
                result.put((Object)"value", (Object)jsonIntArray);
                return result;
            }
            case TAG_LIST: {
                JSONArray jsonArray = new JSONArray();
                for (Object elem : (NbtList)nbtBase) {
                    jsonArray.add(elem);
                }
                result.put((Object)"value", (Object)jsonArray);
                return result;
            }
            case TAG_COMPOUND: {
                JSONObject jsonObject = new JSONObject();
                for (NbtBase member : (NbtCompound)nbtBase) {
                    if (member.getType() == NbtType.TAG_END) continue;
                    jsonObject.put((Object)member.getName(), (Object)ExprJSONObjectOfPacket.fromNBTBase(member));
                }
                result.put((Object)"value", (Object)jsonObject);
                return result;
            }
        }
        return null;
    }

    public static NbtBase toNBTBase(String name, String typeName, Object value) {
        String elemTypeName;
        NbtType type;
        if (typeName.startsWith("list")) {
            type = NbtType.TAG_LIST;
            elemTypeName = typeName.substring(5);
        } else {
            type = NbtType.valueOf((String)("TAG_" + typeName.toUpperCase()));
            elemTypeName = null;
        }
        Number number = value instanceof Number ? (Number)((Number)value) : (Number)null;
        JSONArray jsonArray = value instanceof JSONArray ? (JSONArray)value : null;
        switch (type) {
            case TAG_BYTE: {
                return NbtFactory.of((String)name, (byte)number.byteValue());
            }
            case TAG_SHORT: {
                return NbtFactory.of((String)name, (short)number.shortValue());
            }
            case TAG_INT: {
                return NbtFactory.of((String)name, (int)number.intValue());
            }
            case TAG_LONG: {
                return NbtFactory.of((String)name, (long)number.longValue());
            }
            case TAG_FLOAT: {
                return NbtFactory.of((String)name, (float)number.floatValue());
            }
            case TAG_DOUBLE: {
                return NbtFactory.of((String)name, (double)number.doubleValue());
            }
            case TAG_STRING: {
                return NbtFactory.of((String)name, (String)((String)value));
            }
            case TAG_BYTE_ARRAY: {
                byte[] bytes = new byte[jsonArray.size()];
                for (int i = 0; i < bytes.length; ++i) {
                    bytes[i] = ((Number)jsonArray.get(i)).byteValue();
                }
                return NbtFactory.of((String)name, (byte[])bytes);
            }
            case TAG_INT_ARRAY: {
                int[] ints = new int[jsonArray.size()];
                for (int i = 0; i < ints.length; ++i) {
                    ints[i] = ((Number)jsonArray.get(i)).intValue();
                }
                return NbtFactory.of((String)name, (int[])ints);
            }
            case TAG_LIST: {
                Object[] nbtBases = new NbtBase[jsonArray.size()];
                for (int i = 0; i < nbtBases.length; ++i) {
                    nbtBases[i] = ExprJSONObjectOfPacket.toNBTBase("", elemTypeName, jsonArray.get(i));
                }
                return NbtFactory.ofList((String)name, (Object[])nbtBases);
            }
            case TAG_COMPOUND: {
                NbtCompound nbtCompound = NbtFactory.ofCompound((String)name);
                ((JSONObject)value).forEach((__, maybeJSONObject) -> {
                    JSONObject jsonObject = (JSONObject)maybeJSONObject;
                    String name1 = (String)jsonObject.get((Object)"name");
                    String typeName1 = (String)jsonObject.get((Object)"type");
                    Object value1 = jsonObject.get((Object)"value");
                    nbtCompound.put(ExprJSONObjectOfPacket.toNBTBase(name1, typeName1, value1));
                });
                return nbtCompound;
            }
        }
        throw new IllegalArgumentException("Illegal NbtType: " + type);
    }

    public static WrappedDataWatcher.Serializer getSerializer(Class c) {
        try {
            WrappedDataWatcher.Serializer serializer = WrappedDataWatcher.Registry.get((Class)c);
            if (serializer != null) {
                return serializer;
            }
            if (WrappedChatComponent.class.isAssignableFrom(c)) {
                return WrappedDataWatcher.Registry.getChatComponentSerializer();
            }
            if (ItemStack.class.isAssignableFrom(c)) {
                return WrappedDataWatcher.Registry.getItemStackSerializer((boolean)false);
            }
            if (WrappedBlockData.class.isAssignableFrom(c)) {
                return WrappedDataWatcher.Registry.getBlockDataSerializer((boolean)false);
            }
            if (Vector3F.class.isAssignableFrom(c)) {
                return WrappedDataWatcher.Registry.getVectorSerializer();
            }
            if (BlockPosition.class.isAssignableFrom(c)) {
                return WrappedDataWatcher.Registry.getBlockPositionSerializer((boolean)false);
            }
            if (EnumWrappers.Direction.class == c) {
                return WrappedDataWatcher.Registry.getDirectionSerializer();
            }
            if (NbtCompound.class.isAssignableFrom(c)) {
                return WrappedDataWatcher.Registry.getNBTCompoundSerializer();
            }
            return null;
        }
        catch (RuntimeException e) {
            Logging.debug(ExprJSONObjectOfPacket.class, e);
            return null;
        }
    }

    public static JSONObject fromWatchableCollection(Collection<WrappedWatchableObject> watchableObjects) {
        JSONObject jsonObject = new JSONObject();
        for (WrappedWatchableObject wrappedWatchableObject : watchableObjects) {
            jsonObject.put((Object)("" + wrappedWatchableObject.getIndex()), wrappedWatchableObject.getValue());
        }
        return jsonObject;
    }

    public static WrappedDataWatcher toDataWatcher(JSONObject jsonObject) {
        Object maybeEntity = jsonObject.get((Object)"entity");
        WrappedDataWatcher dataWatcher = maybeEntity instanceof Entity ? new WrappedDataWatcher((Entity)maybeEntity) : new WrappedDataWatcher();
        jsonObject.forEach((key, value) -> {
            try {
                String keyStr = (String)key;
                int i = Integer.parseInt(keyStr);
                Logging.debug(ExprJSONObjectOfPacket.class, "i = " + i + ", value = " + value + ", value.getClass() = " + value.getClass());
                WrappedDataWatcher.Serializer serializer = ExprJSONObjectOfPacket.getSerializer(value.getClass());
                Logging.debug(ExprJSONObjectOfPacket.class, "serializer = " + serializer);
                if (serializer == null) {
                    dataWatcher.setObject(i, value);
                } else {
                    dataWatcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(i, serializer), value);
                }
            }
            catch (ClassCastException | IllegalArgumentException e) {
                Logging.debug(ExprJSONObjectOfPacket.class, e);
            }
        });
        return dataWatcher;
    }

    public static JSONObject fromGameProfile(WrappedGameProfile gameProfile) {
        JSONObject result = new JSONObject();
        result.put((Object)"name", (Object)gameProfile.getName());
        result.put((Object)"uuid", (Object)gameProfile.getUUID().toString());
        result.put((Object)"skin", Skin.toSkriptSkin(Skin.fromGameProfile(gameProfile)));
        return result;
    }

    public static WrappedGameProfile toGameProfile(JSONObject value) {
        WrappedGameProfile gameProfile = new WrappedGameProfile(UUID.fromString((String)value.get((Object)"uuid")), (String)value.get((Object)"name"));
        gameProfile.getProperties().put((Object)Skin.MULTIMAP_KEY, (Object)Skin.fromSkriptSkin(value.get((Object)"skin")).toWrappedSignedProperty());
        return gameProfile;
    }

    public static void registerConverters() {
        ExprJSONObjectOfPacket.registerSingleConverter("chatcomponent", new PacketJSONConverter(){

            @Override
            public JSONObject get(PacketContainer packet, int index) {
                JSONObject toJson;
                block5: {
                    WrappedChatComponent chatComponent = (WrappedChatComponent)packet.getChatComponents().readSafely(index);
                    Logging.debug(ExprJSONObjectOfPacket.class, "ChatComponent: " + chatComponent);
                    if (chatComponent == null) {
                        return null;
                    }
                    String fromJson = chatComponent.getJson();
                    Logging.debug(ExprJSONObjectOfPacket.class, "FromJson: " + fromJson);
                    JSONParser parser = new JSONParser();
                    toJson = null;
                    try {
                        Object parsedJson = parser.parse(fromJson);
                        if (parsedJson instanceof JSONObject) {
                            toJson = (JSONObject)parsedJson;
                            break block5;
                        }
                        if (parsedJson instanceof String) {
                            toJson = new JSONObject();
                            toJson.put((Object)"text", parsedJson);
                            break block5;
                        }
                        throw new IllegalStateException("The json: " + fromJson + "; is neither a jsonobject nor a string");
                    }
                    catch (IllegalStateException | ParseException e) {
                        Logging.debug(ExprJSONObjectOfPacket.class, (Exception)e);
                    }
                }
                return toJson;
            }

            @Override
            public void set(PacketContainer packet, int index, JSONObject value) {
                WrappedChatComponent chatComponent = WrappedChatComponent.fromJson((String)value.toString());
                packet.getChatComponents().writeSafely(index, (Object)chatComponent);
            }
        });
        ExprJSONObjectOfPacket.registerSingleConverter("serverping", new PacketJSONConverter(){

            @Override
            public JSONObject get(PacketContainer packet, int index) {
                try {
                    WrappedServerPing serverPing = (WrappedServerPing)packet.getServerPings().readSafely(0);
                    if (serverPing == null) {
                        return null;
                    }
                    return (JSONObject)new JSONParser().parse(serverPing.toJson());
                }
                catch (ClassCastException | ParseException e) {
                    Logging.reportException(ExprJSONObjectOfPacket.class, (Exception)e);
                    return null;
                }
            }

            @Override
            public void set(PacketContainer packet, int index, JSONObject value) {
                packet.getServerPings().writeSafely(0, (Object)WrappedServerPing.fromJson((String)value.toJSONString()));
            }
        });
        ExprJSONObjectOfPacket.registerSingleConverter("datawatcher", new PacketJSONConverter(){

            @Override
            public JSONObject get(PacketContainer packet, int index) {
                WrappedDataWatcher dataWatcher = (WrappedDataWatcher)packet.getDataWatcherModifier().readSafely(index);
                if (dataWatcher == null) {
                    return null;
                }
                JSONObject jsonObject = ExprJSONObjectOfPacket.fromWatchableCollection(dataWatcher.getWatchableObjects());
                jsonObject.put((Object)"entity", (Object)dataWatcher.getEntity());
                return jsonObject;
            }

            @Override
            public void set(PacketContainer packet, int index, JSONObject value) {
                packet.getDataWatcherModifier().writeSafely(index, (Object)ExprJSONObjectOfPacket.toDataWatcher(value));
            }
        });
        ExprJSONObjectOfPacket.registerSingleConverter("watchablecollection", new PacketJSONConverter(){

            @Override
            public JSONObject get(PacketContainer packet, int index) {
                Collection wrappedWatchableObjects = (Collection)packet.getWatchableCollectionModifier().readSafely(index);
                if (wrappedWatchableObjects == null) {
                    return null;
                }
                return ExprJSONObjectOfPacket.fromWatchableCollection(wrappedWatchableObjects);
            }

            @Override
            public void set(PacketContainer packet, int index, JSONObject value) {
                packet.getWatchableCollectionModifier().writeSafely(index, (Object)ExprJSONObjectOfPacket.toDataWatcher(value).getWatchableObjects());
            }
        });
        ExprJSONObjectOfPacket.registerSingleConverter("gameprofile", new PacketJSONConverter(){

            @Override
            public JSONObject get(PacketContainer packet, int index) {
                return ExprJSONObjectOfPacket.fromGameProfile((WrappedGameProfile)packet.getGameProfiles().readSafely(index));
            }

            @Override
            public void set(PacketContainer packet, int index, JSONObject value) {
                packet.getGameProfiles().writeSafely(index, (Object)ExprJSONObjectOfPacket.toGameProfile(value));
            }
        });
        ExprJSONObjectOfPacket.registerSingleConverter("nbt", new PacketJSONConverter(){

            @Override
            public JSONObject get(PacketContainer packet, int index) {
                return ExprJSONObjectOfPacket.fromNBTBase((NbtBase)packet.getNbtModifier().readSafely(index));
            }

            @Override
            public void set(PacketContainer packet, int index, JSONObject value) {
                try {
                    String name1 = (String)value.get((Object)"name");
                    String typeName1 = (String)value.get((Object)"type");
                    Object value1 = value.get((Object)"value");
                    packet.getNbtModifier().writeSafely(index, (Object)ExprJSONObjectOfPacket.toNBTBase(name1, typeName1, value1));
                }
                catch (ClassCastException | IllegalArgumentException | NullPointerException e) {
                    Logging.debug(ExprJSONObjectOfPacket.class, e);
                }
            }
        });
        ExprJSONObjectOfPacket.registerPluralConverter("chatcomponent", new PacketInfoConverter<JSONObject[]>(JSONObject[].class){

            @Override
            public JSONObject[] get(PacketContainer packet, int index) {
                WrappedChatComponent[] chatComponents = (WrappedChatComponent[])packet.getChatComponentArrays().readSafely(index);
                if (chatComponents == null) {
                    return null;
                }
                JSONObject[] result = new JSONObject[chatComponents.length];
                for (int i = 0; i < chatComponents.length; ++i) {
                    WrappedChatComponent chatComponent = chatComponents[i];
                    String fromjson = chatComponent.getJson();
                    JSONParser parser = new JSONParser();
                    JSONObject tojson = null;
                    try {
                        tojson = (JSONObject)parser.parse(fromjson);
                    }
                    catch (ClassCastException | ParseException e) {
                        Logging.debug(ExprJSONObjectOfPacket.class, (Exception)e);
                    }
                    result[i] = tojson;
                }
                return result;
            }

            @Override
            public void set(PacketContainer packet, int index, JSONObject[] value) {
                WrappedChatComponent[] result = new WrappedChatComponent[value.length];
                for (int i = 0; i < value.length; ++i) {
                    result[i] = WrappedChatComponent.fromJson((String)value[i].toJSONString());
                }
                packet.getChatComponentArrays().writeSafely(index, (Object)result);
            }
        });
        ExprJSONObjectOfPacket.registerPluralConverter("playerinfodata", new PacketInfoConverter<JSONObject[]>(JSONObject[].class){

            @Override
            public JSONObject[] get(PacketContainer packet, int index) {
                try {
                    List playerInfoDatas = (List)packet.getPlayerInfoDataLists().readSafely(index);
                    if (playerInfoDatas == null) {
                        return null;
                    }
                    JSONObject[] result = new JSONObject[playerInfoDatas.size()];
                    for (int i = 0; i < result.length; ++i) {
                        PlayerInfoData playerInfoData = (PlayerInfoData)playerInfoDatas.get(i);
                        Logging.debug(ExprJSONObjectOfPacket.class, "PlayerInfoData: " + playerInfoData);
                        Logging.debug(ExprJSONObjectOfPacket.class, "PlayerInfoData.getDisplayName(): " + playerInfoData.getDisplayName());
                        result[i] = new JSONObject();
                        if (playerInfoData.getDisplayName() != null) {
                            result[i].put((Object)"displayname", new JSONParser().parse(playerInfoData.getDisplayName().getJson()));
                        }
                        result[i].put((Object)"gamemode", (Object)playerInfoData.getGameMode().toBukkit());
                        result[i].put((Object)"latency", (Object)playerInfoData.getLatency());
                        result[i].put((Object)"gameprofile", (Object)ExprJSONObjectOfPacket.fromGameProfile(playerInfoData.getProfile()));
                    }
                    return result;
                }
                catch (ParseException e) {
                    Logging.reportException(ExprJSONObjectOfPacket.class, (Exception)((Object)e));
                    return new JSONObject[0];
                }
            }

            @Override
            public void set(PacketContainer packet, int index, JSONObject[] value) {
                ArrayList<PlayerInfoData> playerInfoDatas = new ArrayList<PlayerInfoData>();
                for (JSONObject jsonObject : value) {
                    Object displayName = jsonObject.get((Object)"displayname");
                    playerInfoDatas.add(new PlayerInfoData(ExprJSONObjectOfPacket.toGameProfile((JSONObject)jsonObject.get((Object)"gameprofile")), ((Number)jsonObject.get((Object)"latency")).intValue(), EnumWrappers.NativeGameMode.fromBukkit((GameMode)((GameMode)jsonObject.get((Object)"gamemode"))), displayName == null ? null : WrappedChatComponent.fromJson((String)displayName.toString())));
                }
                packet.getPlayerInfoDataLists().writeSafely(index, playerInfoDatas);
            }
        });
    }

    public static void registerSingleConverter(String name, PacketInfoConverter<JSONObject> converter) {
        singleConverters.put(name, converter);
    }

    public static void registerPluralConverter(String name, PacketInfoConverter<JSONObject[]> converter) {
        pluralConverters.put(name, converter);
    }

    public static PacketInfoConverter<JSONObject> getSingleConverter(String name) {
        return singleConverters.get(name);
    }

    public static PacketInfoConverter<JSONObject[]> getPluralConverter(String name) {
        return pluralConverters.get(name);
    }

    public static String getConverterNamesPattern(Boolean isSingle) {
        String result = "";
        int i = 0;
        for (String name : isSingle != false ? singleConverters.keySet() : pluralConverters.keySet()) {
            result = result + "|" + ++i + "\u00a6" + name;
        }
        return result;
    }

    public static String getConverterNameByIndex(int index, Boolean isSingle) {
        int i = 0;
        for (String name : isSingle != false ? singleConverters.keySet() : pluralConverters.keySet()) {
            if (++i != index) continue;
            return name;
        }
        return null;
    }

    protected JSONObject[] get(Event event) {
        JSONObject[] jSONObjectArray;
        PacketContainer packet = (PacketContainer)this.packetContainerExpression.getSingle(event);
        int index = ((Number)this.index.getSingle(event)).intValue();
        Logging.debug((Object)this, " ore calling function :" + packet);
        Logging.debug((Object)this, "Converters == " + this.singleConverter + " , " + this.pluralConverter);
        if (this.isSingle) {
            JSONObject[] jSONObjectArray2 = new JSONObject[1];
            jSONObjectArray = jSONObjectArray2;
            jSONObjectArray2[0] = this.singleConverter.get(packet, index);
        } else {
            jSONObjectArray = this.pluralConverter.get(packet, index);
        }
        return jSONObjectArray;
    }

    public boolean isSingle() {
        return this.isSingle;
    }

    public Class<JSONObject> getReturnType() {
        return JSONObject.class;
    }

    public String toString(Event event, boolean b) {
        return "%string% pjson %number% of %packet%";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        String string;
        boolean bl = this.isSingle = i == 0;
        if (expressions[0] == null) {
            string = ExprJSONObjectOfPacket.getConverterNameByIndex(parseResult.mark, this.isSingle);
        } else if (expressions[0] instanceof Literal) {
            string = (String)((Literal)expressions[0]).getSingle();
        } else if (expressions[0] instanceof VariableString) {
            String fullstring = ((VariableString)expressions[0]).toString();
            string = fullstring.substring(1, fullstring.length() - 1);
        } else {
            Skript.error((String)("The string '" + expressions[0] + "' is not a literal string! Only literal strings can be used in the pjson expression!"));
            return false;
        }
        Logging.debug((Object)this, "String == " + string + " isSingle == " + this.isSingle);
        this.index = expressions[1];
        this.packetContainerExpression = expressions[2];
        this.singleConverter = ExprJSONObjectOfPacket.getSingleConverter(string.toLowerCase());
        this.pluralConverter = ExprJSONObjectOfPacket.getPluralConverter(string.toLowerCase());
        Logging.debug((Object)this, "Converters == " + this.singleConverter + " , " + this.pluralConverter);
        if (this.isSingle ? this.singleConverter == null : this.pluralConverter == null) {
            Skript.error((String)("The string " + string + " is not a valid packetinfo!"));
            return false;
        }
        return true;
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        PacketContainer packet = (PacketContainer)this.packetContainerExpression.getSingle(event);
        int index = ((Number)this.index.getSingle(event)).intValue();
        Logging.debug((Object)this, "Packet before calling function :" + packet);
        if (this.isSingle) {
            this.singleConverter.set(packet, index, (JSONObject)delta[0]);
        } else {
            JSONObject[] deltaJSON = new JSONObject[delta.length];
            for (int i = 0; i < delta.length; ++i) {
                deltaJSON[i] = (JSONObject)delta[i];
            }
            this.pluralConverter.set(packet, index, deltaJSON);
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            if (this.isSingle) {
                return (Class[])CollectionUtils.array((Object[])new Class[]{JSONObject.class});
            }
            return (Class[])CollectionUtils.array((Object[])new Class[]{JSONObject[].class});
        }
        return null;
    }

    public static abstract class PacketJSONConverter
    extends PacketInfoConverter<JSONObject> {
        protected PacketJSONConverter() {
            super(JSONObject.class);
        }
    }
}

