/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.thatpacketaddon.syntaxes;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;

public class ExprEntityFieldOfPacket
extends SimpleExpression<Entity> {
    private Expression<Number> index;
    private Expression<PacketContainer> packetContainerExpression;
    private Expression<World> worldExpression;
    private boolean isSingle;

    protected Entity[] get(Event event) {
        PacketContainer packet = (PacketContainer)this.packetContainerExpression.getSingle(event);
        World world = (World)this.worldExpression.getSingle(event);
        int index = ((Number)this.index.getSingle(event)).intValue();
        if (this.isSingle) {
            return new Entity[]{(Entity)packet.getEntityModifier(world).readSafely(index)};
        }
        int[] entityIDs = (int[])packet.getIntegerArrays().readSafely(index);
        Entity[] result = new Entity[entityIDs.length];
        for (int i = 0; i < entityIDs.length; ++i) {
            result[i] = ProtocolLibrary.getProtocolManager().getEntityFromID(world, entityIDs[i]);
        }
        return result;
    }

    public boolean isSingle() {
        return this.isSingle;
    }

    public Class<? extends Entity> getReturnType() {
        return Entity.class;
    }

    public String toString(Event event, boolean b) {
        return this.worldExpression + " entity" + (this.isSingle ? "" : " array") + " field " + this.index + " of " + this.packetContainerExpression;
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.isSingle = i == 0;
        this.index = expressions[1];
        this.packetContainerExpression = expressions[2];
        this.worldExpression = expressions[0];
        return true;
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        PacketContainer packet = (PacketContainer)this.packetContainerExpression.getSingle(event);
        World world = (World)this.worldExpression.getSingle(event);
        int index = ((Number)this.index.getSingle(event)).intValue();
        if (this.isSingle) {
            packet.getEntityModifier(world).writeSafely(index, (Object)((Entity)delta[0]));
        } else {
            int[] entityIDs = new int[delta.length];
            for (int i = 0; i < delta.length; ++i) {
                entityIDs[i] = ((Entity)delta[i]).getEntityId();
            }
            packet.getIntegerArrays().writeSafely(index, (Object)entityIDs);
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return this.isSingle ? (Class[])CollectionUtils.array((Object[])new Class[]{Entity.class}) : (Class[])CollectionUtils.array((Object[])new Class[]{Entity[].class});
        }
        return null;
    }
}

