/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.thatpacketaddon.syntaxes;

import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Version;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.reflect.EquivalentConverter;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.wrappers.BlockPosition;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.MinecraftKey;
import com.comphenix.protocol.wrappers.PlayerInfoData;
import com.comphenix.protocol.wrappers.Vector3F;
import com.comphenix.protocol.wrappers.WrappedBlockData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.comphenix.protocol.wrappers.WrappedServerPing;
import com.comphenix.protocol.wrappers.nbt.NbtBase;
import com.comphenix.protocol.wrappers.nbt.NbtCompound;
import com.comphenix.protocol.wrappers.nbt.NbtFactory;
import com.comphenix.protocol.wrappers.nbt.NbtList;
import com.comphenix.protocol.wrappers.nbt.NbtType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.Difficulty;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.WorldType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.bukkit.util.Vector;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import us.tlatoani.thatpacketaddon.core.base.Logging;
import us.tlatoani.thatpacketaddon.core.reflection.Reflection;
import us.tlatoani.thatpacketaddon.player_info_data.ExprGameModeOfPlayerInfoData;
import us.tlatoani.thatpacketaddon.syntaxes_legacy.ExprJSONObjectOfPacket;
import us.tlatoani.thatpacketaddon.syntaxes_legacy.ExprObjectOfPacket;
import us.tlatoani.thatpacketaddon.util.PacketField;
import us.tlatoani.thatpacketaddon.util.PacketFieldDocumentationBuilder;
import us.tlatoani.thatpacketaddon.util.WatchableType;

public class Converters {
    private static final List<PacketField> fields = new ArrayList<PacketField>();
    private static final List<WatchableType> watchables = new ArrayList<WatchableType>();

    public static PacketField getField(int ix) {
        return fields.get(ix);
    }

    public static Stream<String> getFieldNames() {
        return fields.stream().map(field -> field.name);
    }

    public static WatchableType getWatchable(int ix) {
        return watchables.get(ix);
    }

    public static Stream<String> getWatchableNames() {
        return watchables.stream().map(watchable -> watchable.name);
    }

    public static <T> PacketFieldDocumentationBuilder registerField(String name, Class<T> type, Function<PacketContainer, StructureModifier<T>> function) {
        fields.add(PacketField.simple(name, type, function));
        return new PacketFieldDocumentationBuilder(name, type);
    }

    public static <F, T> PacketFieldDocumentationBuilder registerField(String name, Class<T> type, Function<PacketContainer, StructureModifier<F>> function, Function<? super F, ? extends T> get, Function<? super T, ? extends F> set) {
        fields.add(PacketField.converted(name, type, function, get, set));
        return new PacketFieldDocumentationBuilder(name, type);
    }

    public static <T> void registerWatchable(String name, Class<T> type) {
        Converters.registerWatchable(name, type, () -> WrappedDataWatcher.Registry.get((Class)type, (boolean)false));
    }

    public static <T> void registerWatchable(String name, Class<T> type, Function<Boolean, WrappedDataWatcher.Serializer> serializerSupplier) {
        WrappedDataWatcher.Serializer serializer = null;
        try {
            serializer = serializerSupplier.apply(false);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        watchables.add(WatchableType.simple(name, type, serializer));
    }

    public static <T> void registerWatchable(String name, Class<T> type, Supplier<WrappedDataWatcher.Serializer> serializerSupplier) {
        WrappedDataWatcher.Serializer serializer = null;
        try {
            serializer = serializerSupplier.get();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        watchables.add(WatchableType.simple(name, type, serializer));
    }

    public static <F, T> void registerWatchable(String name, Class<T> type, Class<F> wrappedType, Function<? super F, ? extends T> get, Function<? super T, ? extends F> set) {
        Converters.registerWatchable(name, type, wrappedType, () -> WrappedDataWatcher.Registry.get((Class)wrappedType, (boolean)false), get, set);
    }

    public static <F, T> void registerWatchable(String name, Class<T> type, Class<F> wrappedType, Function<Boolean, WrappedDataWatcher.Serializer> serializerSupplier, Function<? super F, ? extends T> get, Function<? super T, ? extends F> set) {
        WrappedDataWatcher.Serializer serializer = null;
        try {
            serializer = serializerSupplier.apply(false);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        watchables.add(WatchableType.converted(name, type, wrappedType, serializer, get, set));
    }

    public static <F, T> void registerWatchable(String name, Class<T> type, Class<F> wrappedType, Supplier<WrappedDataWatcher.Serializer> serializerSupplier, Function<? super F, ? extends T> get, Function<? super T, ? extends F> set) {
        WrappedDataWatcher.Serializer serializer = null;
        try {
            serializer = serializerSupplier.get();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        watchables.add(WatchableType.converted(name, type, wrappedType, serializer, get, set));
    }

    public static <F, T> void registerOptionalWatchable(String name, Class<T> type, Class<F> wrappedType, Function<? super F, ? extends T> get, Function<? super T, ? extends F> set) {
        Converters.registerOptionalWatchable(name, type, wrappedType, b -> WrappedDataWatcher.Registry.get((Class)wrappedType, (boolean)b), get, set);
    }

    public static <F, T> void registerOptionalWatchable(String name, Class<T> type, Class<F> wrappedType, Function<Boolean, WrappedDataWatcher.Serializer> serializerSupplier, Function<? super F, ? extends T> get, Function<? super T, ? extends F> set) {
        WrappedDataWatcher.Serializer serializer = null;
        try {
            serializer = serializerSupplier.apply(true);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        watchables.add(WatchableType.optional(name, type, wrappedType, serializer, get, set));
    }

    public static void registerFields() {
        Method[] packetMethods;
        Converters.registerField("Object", Object.class, PacketContainer::getModifier).document("1.0", "The value of the field numbered at the specified index of the specified packet's fields.");
        Converters.registerField("Boolean", Boolean.class, PacketContainer::getBooleans).document("1.0");
        Converters.registerField("String", String.class, PacketContainer::getStrings).document("1.0");
        Converters.registerField("String Array", String[].class, PacketContainer::getStringArrays).document("1.0");
        Converters.registerField("Byte", Number.class, PacketContainer::getBytes, Function.identity(), Number::byteValue).document("1.0");
        Converters.registerField("Short", Number.class, PacketContainer::getShorts, Function.identity(), Number::shortValue).document("1.0");
        Converters.registerField("Int", Number.class, PacketContainer::getIntegers, Function.identity(), Number::intValue).document("1.0");
        Converters.registerField("Long", Number.class, PacketContainer::getLongs, Function.identity(), Number::longValue).document("1.0");
        Converters.registerField("Float", Number.class, PacketContainer::getFloat, Function.identity(), Number::floatValue).document("1.0");
        Converters.registerField("Double", Number.class, PacketContainer::getDoubles, Function.identity(), Number::doubleValue).document("1.0");
        Converters.registerField("Byte Array", Number[].class, PacketContainer::getByteArrays, bytes -> {
            Number[] result = new Number[((byte[])bytes).length];
            for (int i = 0; i < ((byte[])bytes).length; ++i) {
                result[i] = bytes[i];
            }
            return result;
        }, numbers -> {
            byte[] result = new byte[((Number[])numbers).length];
            for (int i = 0; i < ((Number[])numbers).length; ++i) {
                result[i] = numbers[i].byteValue();
            }
            return result;
        }).document("1.0");
        Converters.registerField("Int Array", Number[].class, PacketContainer::getIntegerArrays, ints -> {
            Number[] result = new Number[((int[])ints).length];
            for (int i = 0; i < ((int[])ints).length; ++i) {
                result[i] = ints[i];
            }
            return result;
        }, numbers -> {
            int[] result = new int[((Number[])numbers).length];
            for (int i = 0; i < ((Number[])numbers).length; ++i) {
                result[i] = numbers[i].intValue();
            }
            return result;
        }).document("1.0");
        Converters.registerField("Itemstack", ItemStack.class, PacketContainer::getItemModifier).document("1.0");
        Converters.registerField("Itemstack Array", ItemStack[].class, PacketContainer::getItemArrayModifier).document("1.0");
        Converters.registerField("Itemstack List", ItemStack[].class, PacketContainer::getItemListModifier, list -> list.toArray(new ItemStack[0]), Arrays::asList).document("1.0");
        Converters.registerField("Block", ItemStack.class, PacketContainer::getBlocks, ItemStack::new, ItemStack::getType).document("1.0", "The value of the field numbered at the specified index of the specified packet's block fields. Note that this is represented in Skript as an itemstack with the material of the block.");
        Converters.registerField("Blockdata", ItemStack.class, PacketContainer::getBlockData, Converters::fromWrappedBlockData, Converters::toWrappedBlockData).document("1.0", "The value of the field numbered at the specified index of the specified packet's blockdata fields. Note that this is represented in Skript as an itemstack with the material and data of the blockdata.");
        try {
            Class<?> nmsItemClass = Reflection.getMinecraftClass("Item");
            final Reflection.MethodInvoker asNMSCopy = Reflection.getTypedMethod(Reflection.getCraftBukkitClass("inventory.CraftItemStack"), "asNMSCopy", Reflection.getMinecraftClass("ItemStack"), ItemStack.class);
            final Reflection.MethodInvoker getNMSItem = Reflection.getTypedMethod(Reflection.getMinecraftClass("ItemStack"), "getItem", nmsItemClass, new Class[0]);
            final Reflection.MethodInvoker asNewCraftStack = Reflection.getTypedMethod(Reflection.getCraftBukkitClass("inventory.CraftItemStack"), "asNewCraftStack", Reflection.getCraftBukkitClass("inventory.CraftItemStack"), nmsItemClass);
            EquivalentConverter<ItemStack> itemConvert = new EquivalentConverter<ItemStack>(){

                public ItemStack getSpecific(Object o) {
                    return (ItemStack)asNewCraftStack.invoke(null, o);
                }

                public Object getGeneric(ItemStack itemStack) {
                    return getNMSItem.invoke(asNMSCopy.invoke(null, itemStack), new Object[0]);
                }

                public Object getGeneric(Class<?> aClass, ItemStack itemStack) {
                    return this.getGeneric(itemStack);
                }

                public Class<ItemStack> getSpecificType() {
                    return ItemStack.class;
                }
            };
            Converters.registerField("Item", ItemStack.class, arg_0 -> Converters.lambda$registerFields$10(nmsItemClass, (EquivalentConverter)itemConvert, arg_0)).document("1.0");
        }
        catch (Exception e2) {
            Logging.reportException(ExprObjectOfPacket.class, e2);
        }
        Converters.registerField("Location", Location.class, PacketContainer::getBlockPositionModifier, Converters::fromBlockPosition, Converters::toBlockPosition).document("1.0", "The value of the field numbered at the specified index of the specified packet's location fields. Note that Minecraft's BlockPosition class does not have information about the world, so the returned location will be in your server's main world. Presumably (if you have more than one world) you will want to set this to be the appropriate world given the context.");
        Converters.registerField("Location Collection", Location[].class, PacketContainer::getBlockPositionCollectionModifier, collection -> (Location[])collection.stream().map(Converters::fromBlockPosition).toArray(Location[]::new), array -> Arrays.stream(array).map(Converters::toBlockPosition).collect(Collectors.toList())).document("1.0", "The value of the field numbered at the specified index of the specified packet's location collection fields. Note that Minecraft's BlockPosition class does not have information about the world, so the returned locations will be in your server's main world. Presumably (if you have more than one world) you will want to set them to be the appropriate world given the context.");
        Converters.registerField("UUID", String.class, PacketContainer::getUUIDs, UUID::toString, UUID::fromString).document("1.0", "The value of the field numbered at the specified index of the specified packet's UUID fields. Note that UUIDs will be returned as a string with dashes, and strings used for setting should also have dashes.");
        if (Bukkit.getPluginManager().getPlugin("Kosmos") != null) {
            Converters.registerField("Worldtype", WorldType.class, PacketContainer::getWorldTypeModifier).document("1.0").requiredPlugins(new String[]{"Kosmos"});
        }
        Converters.registerField("Minecraft Key", MinecraftKey.class, PacketContainer::getMinecraftKeys).document("1.0");
        Converters.registerField("Collection", Object[].class, packet -> packet.getSpecificModifier(Collection.class), Collection::toArray, Arrays::asList).document("1.0");
        Reflection.ConstructorInvoker packetDataSerializerConstructor = Reflection.getConstructor(Reflection.getMinecraftClass("PacketDataSerializer"), ByteBuf.class);
        Converters.registerField("Byte Buffer", Number[].class, packet -> packet.getSpecificModifier(ByteBuf.class), byteBuf -> {
            Number[] result = new Number[byteBuf.writerIndex()];
            for (int i = 0; i < byteBuf.writerIndex(); ++i) {
                result[i] = byteBuf.getByte(i);
            }
            return result;
        }, numbers -> {
            byte[] bytes = new byte[((Number[])numbers).length];
            for (int i = 0; i < ((Number[])numbers).length; ++i) {
                bytes[i] = numbers[i].byteValue();
            }
            ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])bytes);
            return (ByteBuf)packetDataSerializerConstructor.invoke(byteBuf);
        }).document("1.0");
        Converters.registerField("Gamemode", GameMode.class, PacketContainer::getGameModes, EnumWrappers.NativeGameMode::toBukkit, ExprGameModeOfPlayerInfoData::toNative).document("1.0", "The value of the field numbered at the specified index of the specified packet's gamemode fields. Note that ProtocolLib's NativeGameMode class also has a NOT_SET mode, which will appear as the field being not set. If you want to deal more directly with the NOT_SET mode, you can use the NativeGameMode Field of Packet expression.");
        Converters.registerField("Difficulty", Difficulty.class, PacketContainer::getDifficulties, Converters::fromWrapperDifficulty, Converters::toWrapperDifficulty).document("1.0");
        Converters.registerField("Profile", WrappedGameProfile.class, PacketContainer::getGameProfiles).document("1.0");
        Converters.registerField("PlayerInfoData List", PlayerInfoData[].class, PacketContainer::getPlayerInfoDataLists, list -> list.toArray(new PlayerInfoData[0]), Arrays::asList).document("1.0");
        Converters.registerField("Server Ping", WrappedServerPing.class, PacketContainer::getServerPings).document("1.0");
        if (Classes.getExactClassInfo(Vector.class) != null) {
            Converters.registerField("Vector", Vector.class, PacketContainer::getVectors).document("1.0", "The value of the field numbered at the specified index of the specified packet's playerinfodata list fields. Note that you need a version of Skript that has vectors in order to use this packet field.");
        }
        Converters.registerField("Dimension ID", Number.class, PacketContainer::getDimensions, Function.identity(), Number::intValue).document("1.0", "The value of the field numbered at the specified index of the specified packet's dimension id fields. 0 represents the overworld, -1 represents the nether, and 1 represents the end.");
        Converters.registerField("Chat Component", JSONObject.class, PacketContainer::getChatComponents, Converters::fromWrappedChatComponent, Converters::toWrappedChatComponent).document("1.0", "The value of the field numbered at the specified index of the specified packet's chat component fields. The chat component is represented as a jsonobject.");
        Converters.registerField("Chat Component Array", JSONObject[].class, PacketContainer::getChatComponentArrays, array -> (JSONObject[])Arrays.stream(array).map(Converters::fromWrappedChatComponent).toArray(JSONObject[]::new), array -> (WrappedChatComponent[])Arrays.stream(array).map(Converters::toWrappedChatComponent).toArray(WrappedChatComponent[]::new)).document("1.0", "The value of the field numbered at the specified index of the specified packet's chat component array fields. The chat components are represented as a jsonobject.");
        Converters.registerField("NBT", JSONObject.class, PacketContainer::getNbtModifier, Converters::fromNBTBase, Converters::toNBTBase).document("1.0", "The value of the field numbered at the specified index of the specified packet's NBT fields. The NBT, as well as any NBT values contained in it, is represented as a jsonobject with three parts:\nThe name, with index/key \"name\", which is just the name (sometimes null)\nThe type, with index/key \"type\", which is the type of NBT, and can have the following values:\n- \"byte\", \"short\", \"int\", \"long\", \"float\", \"double\", the basic number types\n- \"string\", for strings\n- \"byte_array\" and \"int_array\", for basic number array types\n- \"compound\", for an NBT compound\n- \"list_something\", such as \"list_string\" or \"list_compound\", for a list of some other type\nThe value, with index/key \"value\", which is the actual value:\n- In the cases of the number types and string type this is just the number/string (when accessing using a list variable in Skript it's like {_nbt::value}\n- In the case of the number array types and the list type this is an array of the objects (when accessing using a list variable in Skript it's like {_nbt::value::*}, ex. {_nbt::value::1} for the first element)\n- In the case of the compound it's a JSONObject of the NBT values, each also having its own name, type and value (when accessing through a list variable in Skript it's: {_nbt::value::example_name::name} for the name (which is the same as the index, so it will be \"example_name\"), {_nbt::value::example_name::type} for the type, let's say \"string\", and {_nbt::value::example_name::value} for the actual value, let's say \"pie\")");
        Converters.registerField("NBT List", JSONObject[].class, PacketContainer::getListNbtModifier, list -> {
            JSONObject[] array = new JSONObject[list.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = Converters.fromNBTBase((NbtBase)list.get(i));
            }
            return array;
        }, array -> {
            ArrayList<NbtBase> list = new ArrayList<NbtBase>(((JSONObject[])array).length);
            for (JSONObject jsonObject : array) {
                list.add(Converters.toNBTBase(jsonObject));
            }
            return list;
        }).document("1.0", "The value of the field numbered at the specified index of the specified packet's NBT list fields. The NBT values contained int list, as well as any NBT values contained in those NBT values, are represented as a jsonobject with three parts:\nThe name, with index/key \"name\", which is just the name (sometimes null)\nThe type, with index/key \"type\", which is the type of NBT, and can have the following values:\n- \"byte\", \"short\", \"int\", \"long\", \"float\", \"double\", the basic number types\n- \"string\", for strings\n- \"byte_array\" and \"int_array\", for basic number array types\n- \"compound\", for an NBT compound\n- \"list_something\", such as \"list_string\" or \"list_compound\", for a list of some other type\nThe value, with index/key \"value\", which is the actual value:\n- In the cases of the number types and string type this is just the number/string (when accessing using a list variable in Skript it's like {_nbt::value}\n- In the case of the number array types and the list type this is an array of the objects (when accessing using a list variable in Skript it's like {_nbt::value::*}, ex. {_nbt::value::1} for the first element)\n- In the case of the compound it's a JSONObject of the NBT values, each also having its own name, type and value (when accessing through a list variable in Skript it's: {_nbt::value::example_name::name} for the name (which is the same as the index, so it will be \"example_name\"), {_nbt::value::example_name::type} for the type, let's say \"string\", and {_nbt::value::example_name::value} for the actual value, let's say \"pie\")");
        Converters.registerField("Data Watcher", WrappedDataWatcher.class, PacketContainer::getDataWatcherModifier);
        Converters.registerField("Watchable Collection", WrappedDataWatcher.class, PacketContainer::getWatchableCollectionModifier, WrappedDataWatcher::new, WrappedDataWatcher::getWatchableObjects);
        for (Method method : packetMethods = PacketContainer.class.getMethods()) {
            if (method.getReturnType() != StructureModifier.class) continue;
            try {
                String name;
                ParameterizedType returnType = (ParameterizedType)method.getGenericReturnType();
                Class param = (Class)returnType.getActualTypeArguments()[0];
                if (!param.isEnum() || !param.getName().startsWith("com.comphenix.protocol.wrappers.EnumWrappers") || (name = param.getSimpleName()).equals("Difficulty") || name.equals("WorldType") && Bukkit.getPluginManager().getPlugin("Kosmos") != null) continue;
                Converters.registerField(name, String.class, packet -> {
                    try {
                        return (StructureModifier)method.invoke(packet, new Object[0]);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        Logging.reportException(Converters.class, e);
                        return null;
                    }
                }, Object::toString, str -> Enum.valueOf(param, str.toUpperCase())).document("1.0", "The value of the field numbered at the specified index of the specified packet's " + name.toLowerCase() + " fields. This is an automatically generated enum packet field, and is represented in Skript as a string (the name of the value of the field). The returned name will always be in uppercase, however when setting this expression the cases used do not matter.The different values of this enum are " + Arrays.stream(param.getEnumConstants()).map(e -> '\"' + ((Enum)e).name() + '\"').collect(Collectors.joining(", ")) + ".");
            }
            catch (ClassCastException e3) {
                Logging.debug(Converters.class, e3);
            }
        }
    }

    public static void registerWatchables() {
        Version minecraftVersion = new Version(Bukkit.getVersion().substring(Bukkit.getVersion().indexOf("MC") + 3, Bukkit.getVersion().indexOf(41)));
        Converters.registerWatchable("object", Object.class, () -> null);
        Converters.registerWatchable("boolean", Boolean.class);
        Converters.registerWatchable("string", String.class);
        Converters.registerWatchable("byte", Number.class, Byte.class, Function.identity(), Number::byteValue);
        Converters.registerWatchable("int", Number.class, Integer.class, Function.identity(), Number::intValue);
        Converters.registerWatchable("float", Number.class, Float.class, Function.identity(), Number::floatValue);
        if (!minecraftVersion.isSmallerThan(new Version(new int[]{1, 11}))) {
            Converters.registerWatchable("itemstack", ItemStack.class, WrappedDataWatcher.Registry::getItemStackSerializer);
        }
        Converters.registerOptionalWatchable("blockdata optional", ItemStack.class, WrappedBlockData.class, WrappedDataWatcher.Registry::getBlockDataSerializer, Converters::fromWrappedBlockData, Converters::toWrappedBlockData);
        Converters.registerWatchable("location", Location.class, BlockPosition.class, () -> WrappedDataWatcher.Registry.getBlockPositionSerializer((boolean)false), Converters::fromBlockPosition, Converters::toBlockPosition);
        Converters.registerOptionalWatchable("location optional", Location.class, BlockPosition.class, WrappedDataWatcher.Registry::getBlockPositionSerializer, Converters::fromBlockPosition, Converters::toBlockPosition);
        Converters.registerOptionalWatchable("uuid optional", String.class, UUID.class, UUID::toString, UUID::fromString);
        Converters.registerWatchable("vector3f", Vector.class, Vector3F.class, WrappedDataWatcher.Registry::getVectorSerializer, (? super F vector3F) -> {
            Vector vector = new Vector();
            vector.setX(vector3F.getX());
            vector.setY(vector3F.getY());
            vector.setZ(vector3F.getZ());
            return vector;
        }, (? super T vector) -> {
            Vector3F vector3F = new Vector3F();
            vector3F.setX((float)vector.getX());
            vector3F.setY((float)vector.getY());
            vector3F.setZ((float)vector.getZ());
            return vector3F;
        });
        Converters.registerWatchable("chatcomponent", JSONObject.class, WrappedChatComponent.class, () -> WrappedDataWatcher.Registry.getChatComponentSerializer((boolean)false), Converters::fromWrappedChatComponent, Converters::toWrappedChatComponent);
        try {
            Converters.registerWatchable("nbt json", JSONObject.class, NbtBase.class, WrappedDataWatcher.Registry::getNBTCompoundSerializer, Converters::fromNBTBase, Converters::toNBTBase);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Converters.registerWatchable("direction", String.class, EnumWrappers.Direction.class, WrappedDataWatcher.Registry::getDirectionSerializer, Enum::name, EnumWrappers.Direction::valueOf);
    }

    public static Difficulty fromWrapperDifficulty(EnumWrappers.Difficulty difficulty) {
        return Difficulty.valueOf((String)difficulty.name());
    }

    public static EnumWrappers.Difficulty toWrapperDifficulty(Difficulty difficulty) {
        return EnumWrappers.Difficulty.valueOf((String)difficulty.name());
    }

    public static ItemStack fromWrappedBlockData(WrappedBlockData blockData) {
        ItemStack itemStack = new ItemStack(blockData.getType());
        itemStack.setData(new MaterialData(blockData.getType(), new Integer(blockData.getData()).byteValue()));
        return itemStack;
    }

    public static WrappedBlockData toWrappedBlockData(ItemStack itemStack) {
        return WrappedBlockData.createData((Material)itemStack.getType(), (int)itemStack.getData().getData());
    }

    public static Location fromBlockPosition(BlockPosition pos) {
        return pos.toLocation((World)Bukkit.getWorlds().get(0));
    }

    public static BlockPosition toBlockPosition(Location loc) {
        return new BlockPosition(loc.toVector());
    }

    public static JSONObject fromWrappedChatComponent(WrappedChatComponent chatComponent) {
        JSONObject toJson;
        block4: {
            String fromJson = chatComponent.getJson();
            Logging.debug(ExprJSONObjectOfPacket.class, "FromJson: " + fromJson);
            JSONParser parser = new JSONParser();
            toJson = null;
            try {
                Object parsedJson = parser.parse(fromJson);
                if (parsedJson instanceof JSONObject) {
                    toJson = (JSONObject)parsedJson;
                    break block4;
                }
                if (parsedJson instanceof String) {
                    toJson = new JSONObject();
                    toJson.put((Object)"text", parsedJson);
                    break block4;
                }
                throw new IllegalStateException("The json: " + fromJson + "; is neither a jsonobject nor a string");
            }
            catch (IllegalStateException | ParseException e) {
                Logging.debug(ExprJSONObjectOfPacket.class, (Exception)e);
            }
        }
        return toJson;
    }

    public static WrappedChatComponent toWrappedChatComponent(JSONObject jsonObject) {
        return WrappedChatComponent.fromJson((String)jsonObject.toJSONString());
    }

    public static JSONObject fromNBTBase(NbtBase nbtBase) {
        if (nbtBase == null) {
            return null;
        }
        JSONObject result = new JSONObject();
        result.put((Object)"name", (Object)nbtBase.getName());
        if (nbtBase.getType() == NbtType.TAG_LIST) {
            result.put((Object)"type", (Object)("list_" + ((NbtList)nbtBase).getElementType().toString().substring(4).toLowerCase()));
        } else {
            result.put((Object)"type", (Object)nbtBase.getType().toString().substring(4).toLowerCase());
        }
        switch (nbtBase.getType()) {
            case TAG_BYTE: 
            case TAG_SHORT: 
            case TAG_INT: 
            case TAG_LONG: 
            case TAG_FLOAT: 
            case TAG_DOUBLE: 
            case TAG_STRING: {
                result.put((Object)"value", nbtBase.getValue());
                return result;
            }
            case TAG_BYTE_ARRAY: {
                JSONArray jsonByteArray = new JSONArray();
                for (byte b : (byte[])nbtBase.getValue()) {
                    jsonByteArray.add((Object)b);
                }
                result.put((Object)"value", (Object)jsonByteArray);
                return result;
            }
            case TAG_INT_ARRAY: {
                JSONArray jsonIntArray = new JSONArray();
                for (int i : (int[])nbtBase.getValue()) {
                    jsonIntArray.add((Object)i);
                }
                result.put((Object)"value", (Object)jsonIntArray);
                return result;
            }
            case TAG_LIST: {
                JSONArray jsonArray = new JSONArray();
                for (Object elem : (NbtList)nbtBase) {
                    jsonArray.add(elem);
                }
                result.put((Object)"value", (Object)jsonArray);
                return result;
            }
            case TAG_COMPOUND: {
                JSONObject jsonObject = new JSONObject();
                for (NbtBase member : (NbtCompound)nbtBase) {
                    if (member.getType() == NbtType.TAG_END) continue;
                    jsonObject.put((Object)member.getName(), (Object)Converters.fromNBTBase(member));
                }
                result.put((Object)"value", (Object)jsonObject);
                return result;
            }
        }
        return null;
    }

    public static NbtBase toNBTBase(JSONObject jsonObject) {
        try {
            String name1 = (String)jsonObject.get((Object)"name");
            String typeName1 = (String)jsonObject.get((Object)"type");
            Object value1 = jsonObject.get((Object)"value");
            return Converters.toNBTBase(name1, typeName1, value1);
        }
        catch (ClassCastException | IllegalArgumentException | NullPointerException e) {
            Logging.debug(ExprJSONObjectOfPacket.class, e);
            return null;
        }
    }

    public static NbtBase toNBTBase(String name, String typeName, Object value) {
        String elemTypeName;
        NbtType type;
        if (typeName.startsWith("list")) {
            type = NbtType.TAG_LIST;
            elemTypeName = typeName.substring(5);
        } else {
            type = NbtType.valueOf((String)("TAG_" + typeName.toUpperCase()));
            elemTypeName = null;
        }
        Number number = value instanceof Number ? (Number)((Number)value) : (Number)null;
        JSONArray jsonArray = value instanceof JSONArray ? (JSONArray)value : null;
        switch (type) {
            case TAG_BYTE: {
                return NbtFactory.of((String)name, (byte)number.byteValue());
            }
            case TAG_SHORT: {
                return NbtFactory.of((String)name, (short)number.shortValue());
            }
            case TAG_INT: {
                return NbtFactory.of((String)name, (int)number.intValue());
            }
            case TAG_LONG: {
                return NbtFactory.of((String)name, (long)number.longValue());
            }
            case TAG_FLOAT: {
                return NbtFactory.of((String)name, (float)number.floatValue());
            }
            case TAG_DOUBLE: {
                return NbtFactory.of((String)name, (double)number.doubleValue());
            }
            case TAG_STRING: {
                return NbtFactory.of((String)name, (String)((String)value));
            }
            case TAG_BYTE_ARRAY: {
                byte[] bytes = new byte[jsonArray.size()];
                for (int i = 0; i < bytes.length; ++i) {
                    bytes[i] = ((Number)jsonArray.get(i)).byteValue();
                }
                return NbtFactory.of((String)name, (byte[])bytes);
            }
            case TAG_INT_ARRAY: {
                int[] ints = new int[jsonArray.size()];
                for (int i = 0; i < ints.length; ++i) {
                    ints[i] = ((Number)jsonArray.get(i)).intValue();
                }
                return NbtFactory.of((String)name, (int[])ints);
            }
            case TAG_LIST: {
                Object[] nbtBases = new NbtBase[jsonArray.size()];
                for (int i = 0; i < nbtBases.length; ++i) {
                    nbtBases[i] = Converters.toNBTBase("", elemTypeName, jsonArray.get(i));
                }
                return NbtFactory.ofList((String)name, (Object[])nbtBases);
            }
            case TAG_COMPOUND: {
                NbtCompound nbtCompound = NbtFactory.ofCompound((String)name);
                ((JSONObject)value).forEach((__, maybeJSONObject) -> {
                    JSONObject jsonObject = (JSONObject)maybeJSONObject;
                    String name1 = (String)jsonObject.get((Object)"name");
                    String typeName1 = (String)jsonObject.get((Object)"type");
                    Object value1 = jsonObject.get((Object)"value");
                    nbtCompound.put(Converters.toNBTBase(name1, typeName1, value1));
                });
                return nbtCompound;
            }
        }
        throw new IllegalArgumentException("Illegal NbtType: " + type);
    }

    private static /* synthetic */ StructureModifier lambda$registerFields$10(Class nmsItemClass, EquivalentConverter itemConvert, PacketContainer packet) {
        return packet.getModifier().withType(nmsItemClass, itemConvert);
    }
}

