/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.thatpacketaddon.player_info_data;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.PlayerInfoData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import java.util.Optional;
import org.bukkit.GameMode;
import org.bukkit.event.Event;
import org.json.simple.JSONObject;

public class ExprNewPlayerInfoData
extends SimpleExpression<PlayerInfoData> {
    private Expression<WrappedGameProfile> profileExpression;
    private Optional<Expression<Number>> latencyExpression;
    private Optional<Expression<GameMode>> gameModeExpression;
    private Expression<JSONObject> displayNameExpression;

    protected PlayerInfoData[] get(Event event) {
        WrappedGameProfile profile = (WrappedGameProfile)this.profileExpression.getSingle(event);
        int latency = this.latencyExpression.map(expr -> (Number)expr.getSingle(event)).map(Number::intValue).orElse(0);
        EnumWrappers.NativeGameMode gameMode = this.gameModeExpression.map(expr -> (GameMode)expr.getSingle(event)).map(EnumWrappers.NativeGameMode::fromBukkit).orElse(EnumWrappers.NativeGameMode.NOT_SET);
        Optional<WrappedChatComponent> displayName = Optional.ofNullable(this.displayNameExpression.getSingle(event)).map(JSONObject::toString).map(WrappedChatComponent::fromJson);
        if (profile == null || !displayName.isPresent()) {
            return new PlayerInfoData[0];
        }
        return new PlayerInfoData[]{new PlayerInfoData(profile, latency, gameMode, displayName.get())};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends PlayerInfoData> getReturnType() {
        return PlayerInfoData.class;
    }

    public String toString(Event e, boolean debug) {
        return "playerinfodata with profile " + this.profileExpression + " display name " + this.displayNameExpression + this.latencyExpression.map(expr -> " latency " + expr).orElse("") + this.gameModeExpression.map(expr -> " gamemode " + expr).orElse("");
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.profileExpression = exprs[0];
        this.displayNameExpression = exprs[1];
        this.latencyExpression = Optional.ofNullable(exprs[2]);
        this.gameModeExpression = Optional.ofNullable(exprs[3]);
        return true;
    }
}

