/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.thatpacketaddon.packet_field_alias;

import ch.njol.skript.Skript;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.log.SkriptLogger;
import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import java.util.ArrayList;
import java.util.Optional;
import org.bukkit.event.Event;
import us.tlatoani.thatpacketaddon.core.base.Logging;
import us.tlatoani.thatpacketaddon.core.event_scope.MundoEventScope;
import us.tlatoani.thatpacketaddon.core.event_scope.ScopeUtil;
import us.tlatoani.thatpacketaddon.core.grouped_list.GroupedList;
import us.tlatoani.thatpacketaddon.mundosyntax.ExpressionConstraints;
import us.tlatoani.thatpacketaddon.mundosyntax.SyntaxParser;
import us.tlatoani.thatpacketaddon.mundosyntax.SyntaxPiece;
import us.tlatoani.thatpacketaddon.mundosyntax.VariableCollective;
import us.tlatoani.thatpacketaddon.mundosyntax.VariableUsage;
import us.tlatoani.thatpacketaddon.packet_field_alias.ExprPacketFieldAlias;
import us.tlatoani.thatpacketaddon.packet_field_alias.PacketFieldAlias;

public class ScopePacketFieldAliases
extends MundoEventScope {
    private PacketType packetType;
    private GroupedList.Key key;
    public static final Character SEPARATOR = Character.valueOf('=');
    public static final String SYNTAX_VAR_NAME = "p";

    @Override
    protected void afterInit() {
    }

    public void unregister(Trigger trigger) {
        ExprPacketFieldAlias.unregisterAliases(this.key);
    }

    public void unregisterAll() {
        ExprPacketFieldAlias.unregisterAllAliases();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init(Literal<?>[] literals, int i, SkriptParser.ParseResult parseResult) {
        this.packetType = (PacketType)literals[0].getSingle();
        SectionNode topNode = (SectionNode)SkriptLogger.getNode();
        try {
            ArrayList<PacketFieldAlias> aliases = new ArrayList<PacketFieldAlias>();
            for (Node node : topNode) {
                SkriptLogger.setNode((Node)node);
                if (node instanceof SectionNode) {
                    Skript.error((String)"Packet info aliases should not be sections!");
                    boolean bl = false;
                    return bl;
                }
                int separatorIndex = node.getKey().indexOf(SEPARATOR.charValue());
                if (separatorIndex == -1) {
                    Skript.error((String)("Packet info aliases should be in the format '<new syntax> " + SEPARATOR + " <old syntax>'"));
                    boolean bl = false;
                    return bl;
                }
                String syntax = node.getKey().substring(0, separatorIndex).trim();
                Optional<String> validatedSyntax = ScopePacketFieldAliases.validateAliasSyntax(syntax);
                if (!validatedSyntax.isPresent()) {
                    boolean bl = false;
                    return bl;
                }
                String original = node.getKey().substring(separatorIndex + 1).trim();
                Optional<PacketFieldAlias> aliasOptional = PacketFieldAlias.create(this.packetType, validatedSyntax.get(), original);
                if (!aliasOptional.isPresent()) {
                    Skript.error((String)"Invalid target syntax in the packet info alias!");
                    boolean bl = false;
                    return bl;
                }
                aliases.add(aliasOptional.get());
            }
            this.key = ExprPacketFieldAlias.registerAliases(aliases);
            boolean bl = true;
            return bl;
        }
        finally {
            ScopeUtil.removeSubNodes(topNode);
        }
    }

    private static Optional<String> validateAliasSyntax(String syntax) {
        SyntaxPiece syntaxPiece;
        if (syntax.contains("%p=")) {
            Skript.error((String)"Invalid alias syntax in the packet info alias!");
            return Optional.empty();
        }
        String spComptabile = syntax.replace("%packet%", "%p=-packet%");
        try {
            syntaxPiece = SyntaxParser.parse(spComptabile);
        }
        catch (IllegalArgumentException e) {
            Logging.debug(ScopePacketFieldAliases.class, e);
            Skript.error((String)"Invalid alias syntax in the packet info alias!");
            return Optional.empty();
        }
        catch (Exception e) {
            Logging.reportException(ScopePacketFieldAliases.class, e);
            Skript.error((String)"An error occurred while validating the alias syntax");
            return Optional.empty();
        }
        VariableUsage usage = syntaxPiece.getVariableUsage(SYNTAX_VAR_NAME);
        if (usage == VariableUsage.CONFLICTING) {
            Skript.error((String)"Alias syntax allows conflicting usage of '%packet%'!");
            return Optional.empty();
        }
        VariableCollective variableCollective = syntaxPiece.getVariables();
        ExpressionConstraints constraints = variableCollective.getExpression(SYNTAX_VAR_NAME);
        if (variableCollective.size() > (constraints == null ? 0 : 1) || variableCollective.isVaryingOption(SYNTAX_VAR_NAME)) {
            Skript.error((String)"Invalid alias syntax in the packet info alias!");
            return Optional.empty();
        }
        if (constraints != null) {
            for (ExpressionConstraints.Type type : constraints.types) {
                if (type.classInfo.getC() == PacketContainer.class && type.isSingle) continue;
                Skript.error((String)"Invalid alias syntax in the packet info alias!");
                return Optional.empty();
            }
        }
        return Optional.of(syntaxPiece.actualSyntax(0));
    }

    public String toString(Event event, boolean b) {
        return "packet field aliases for " + this.packetType;
    }
}

