/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.thatpacketaddon.mundosyntax;

import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.registrations.Classes;
import com.google.common.collect.ImmutableSet;
import java.util.stream.Collectors;

public final class ExpressionConstraints {
    public final ImmutableSet<Type> types;
    public final LiteralState isLiteral;
    public final int time;
    public final boolean nullable;

    public ExpressionConstraints(ImmutableSet<Type> types, LiteralState isLiteral, int time, boolean nullable) {
        this.types = types;
        this.isLiteral = isLiteral;
        this.time = time;
        this.nullable = nullable;
    }

    public static ExpressionConstraints fromSyntax(String string) {
        int time;
        boolean nullable;
        LiteralState isLiteral;
        if (string.charAt(0) == '*') {
            isLiteral = LiteralState.LITERAL;
            string = string.substring(1);
        } else if (string.charAt(0) == '~') {
            isLiteral = LiteralState.NONLITERAL;
            string = string.substring(1);
        } else {
            isLiteral = LiteralState.UNKNOWN;
        }
        if (string.charAt(0) == '-') {
            nullable = true;
            string = string.substring(1);
        } else {
            nullable = false;
        }
        if (string.endsWith("@1")) {
            time = 1;
            string = string.substring(0, string.length() - 2);
        } else if (string.endsWith("@-1")) {
            time = -1;
            string = string.substring(0, string.length() - 2);
        } else {
            time = 0;
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String typeStr : string.split("/")) {
            boolean isSingle;
            if (typeStr.endsWith("s")) {
                isSingle = false;
                typeStr = typeStr.substring(0, typeStr.length() - 1);
            } else {
                isSingle = true;
            }
            builder.add((Object)new Type(typeStr, isSingle));
        }
        return new ExpressionConstraints((ImmutableSet<Type>)builder.build(), isLiteral, time, nullable);
    }

    public String getTypeOptions() {
        return this.types.stream().map(type -> type.codename).collect(Collectors.joining("/"));
    }

    public String getSyntax() {
        String timeSuffix = ExpressionConstraints.getTimeSuffix(this.time);
        String nullablePrefix = this.nullable ? "-" : "";
        return this.isLiteral.prefix + nullablePrefix + this.getTypeOptions() + timeSuffix;
    }

    public String toString() {
        return "ExpressionConstraints(types = " + this.types + ", isLiteral = " + (Object)((Object)this.isLiteral) + ", time = " + this.time + ", nullable = " + this.nullable + ")";
    }

    public static String getTimeSuffix(int time) {
        switch (time) {
            case 1: {
                return "@1";
            }
            case -1: {
                return "@-1";
            }
            case 0: {
                return "";
            }
        }
        throw new IllegalArgumentException("Illegal int time value: " + time);
    }

    public static class Type {
        public final ClassInfo classInfo;
        public final String codename;
        public final boolean isSingle;

        public Type(String codename, boolean isSingle) {
            this.codename = codename;
            this.classInfo = Classes.getClassInfo((String)codename);
            this.isSingle = isSingle;
        }

        public boolean equals(Object object) {
            if (object instanceof Type) {
                Type type = (Type)object;
                return this.isSingle == type.isSingle && this.classInfo.equals(type.classInfo);
            }
            return false;
        }

        public String toString() {
            return "Type(classInfo = " + this.codename + ", isSingle = " + this.isSingle + ")";
        }
    }

    public static enum LiteralState {
        LITERAL("*"),
        NONLITERAL("~"),
        UNKNOWN("");

        public final String prefix;

        private LiteralState(String prefix) {
            this.prefix = prefix;
        }

        public LiteralState getByPrefix(String prefix) {
            for (LiteralState literalState : LiteralState.values()) {
                if (!literalState.prefix.equals(prefix)) continue;
                return literalState;
            }
            throw new IllegalArgumentException();
        }
    }
}

