/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.thatpacketaddon.json;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.variables.Variables;
import ch.njol.util.Kleenean;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.event.Event;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import us.tlatoani.thatpacketaddon.core.base.Logging;

public class EffPutJsonInListVariable
extends Effect {
    private Expression<JSONObject> jsonObjectExpression;
    private Variable listVariable;
    String listVariableName;
    private Boolean isArray;

    private static void setFromJSONCompatibleObject(String varName, Object value, Boolean isLocal, Event event) {
        if (value instanceof JSONArray) {
            EffPutJsonInListVariable.setToJSONArray(varName + "::*", (List<Object>)((JSONArray)value), isLocal, event);
        } else if (value instanceof JSONObject) {
            EffPutJsonInListVariable.setToJSONObject(varName + "::*", (JSONObject)value, isLocal, event);
        } else {
            Variables.setVariable((String)varName, (Object)value, (Event)event, (boolean)isLocal);
        }
    }

    private static void setToJSONObject(String variableName, JSONObject jsonObject, Boolean isLocal, Event event) {
        jsonObject.forEach((o, value) -> {
            String key = (String)o;
            String subVarName = variableName.substring(0, variableName.length() - 1) + key;
            EffPutJsonInListVariable.setFromJSONCompatibleObject(subVarName, value, isLocal, event);
        });
    }

    private static void setToJSONArray(final String variableName, List<Object> jsonArray, final Boolean isLocal, final Event event) {
        jsonArray.forEach(new Consumer<Object>(){
            private int index = 0;

            @Override
            public void accept(Object value) {
                ++this.index;
                String subVarName = variableName.substring(0, variableName.length() - 1) + this.index;
                EffPutJsonInListVariable.setFromJSONCompatibleObject(subVarName, value, isLocal, event);
            }
        });
    }

    protected void execute(Event event) {
        if (this.isArray.booleanValue()) {
            Variable listVariable = this.listVariable;
            listVariable.change(event, null, Changer.ChangeMode.DELETE);
            JSONObject[] jsonObjects = (JSONObject[])this.jsonObjectExpression.getArray(event);
            Logging.debug((Object)this, "Expression: " + this.jsonObjectExpression);
            Logging.debug((Object)this, "Array size: " + jsonObjects.length);
            Logging.debug((Object)this, "Actual array: " + jsonObjects);
            List<Object> jsonObjectList = Arrays.asList((Object[])jsonObjects);
            Logging.debug((Object)this, "List size: " + jsonObjectList.size());
            Logging.debug((Object)this, "Actual list: " + jsonObjects);
            EffPutJsonInListVariable.setToJSONArray(this.listVariableName, jsonObjectList, listVariable.isLocal(), event);
        } else {
            JSONObject jsonObject = (JSONObject)this.jsonObjectExpression.getSingle(event);
            if (jsonObject == null) {
                return;
            }
            Variable listVariable = this.listVariable;
            listVariable.change(event, null, Changer.ChangeMode.DELETE);
            EffPutJsonInListVariable.setToJSONObject(this.listVariableName, jsonObject, listVariable.isLocal(), event);
        }
    }

    public String toString(Event event, boolean b) {
        return "put json %jsonobject% in listvar %objects%";
    }

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        Logging.debug((Object)this, "Expression class: " + exprs[1].getClass());
        this.jsonObjectExpression = exprs[0];
        this.isArray = i == 1;
        Logging.debug((Object)this, "Return type: " + exprs[1].getReturnType());
        if (exprs[1] instanceof Variable && ((Variable)exprs[1]).isList()) {
            this.listVariable = (Variable)exprs[1];
            this.listVariableName = this.listVariable.isLocal() ? this.listVariable.toString().substring(2, this.listVariable.toString().length() - 1) : this.listVariable.toString().substring(1, this.listVariable.toString().length() - 1);
            return true;
        }
        Skript.error((String)"'put json %jsonobject% in listvar %objects%' must be used with a list variable!");
        return false;
    }
}

