/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.thatpacketaddon.data_watcher;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;
import us.tlatoani.thatpacketaddon.syntaxes.Converters;
import us.tlatoani.thatpacketaddon.util.WatchableType;

public class ExprWatchedValueOfDataWatcher
extends SimpleExpression<Object> {
    private WatchableType watchableType;
    private Expression<Number> indexExpression;
    private Expression<WrappedDataWatcher> dataWatcherExpression;

    protected Object[] get(Event event) {
        Number index = (Number)this.indexExpression.getSingle(event);
        WrappedDataWatcher dataWatcher = (WrappedDataWatcher)this.dataWatcherExpression.getSingle(event);
        if (index == null || dataWatcher == null) {
            return new Object[0];
        }
        Object object = dataWatcher.getObject(index.intValue());
        return new Object[]{this.watchableType.get(object)};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<?> getReturnType() {
        return this.watchableType.type;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "watched " + this.watchableType.name + " " + this.indexExpression + " of " + this.dataWatcherExpression;
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.watchableType = Converters.getWatchable(matchedPattern);
        this.indexExpression = exprs[0];
        this.dataWatcherExpression = exprs[1];
        return true;
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        Number index = (Number)this.indexExpression.getSingle(event);
        WrappedDataWatcher dataWatcher = (WrappedDataWatcher)this.dataWatcherExpression.getSingle(event);
        if (index == null || dataWatcher == null) {
            return;
        }
        if (mode == Changer.ChangeMode.SET) {
            Object value = this.watchableType.set(delta[0]);
            dataWatcher.setObject(index.intValue(), this.watchableType.serializer, value);
        } else if (mode == Changer.ChangeMode.DELETE) {
            dataWatcher.remove(index.intValue());
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Object.class});
        }
        return null;
    }
}

