/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.thatpacketaddon.core.updating;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.sql.Timestamp;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import us.tlatoani.thatpacketaddon.core.base.Logging;
import us.tlatoani.thatpacketaddon.core.base.MundoAddon;
import us.tlatoani.thatpacketaddon.core.base.Scheduling;
import us.tlatoani.thatpacketaddon.core.updating.HTTPClient;

public class Updating {
    public static final int CONNECTION_TIMEOUT_MS = 10000;
    public static final int READ_TIMEOUT_MS = 10000;

    public static void load() {
        MundoAddon.registerSubCommand(Updating::onUpdateCommand, "update");
        MundoAddon.registerSubCommandDescription("update info", "Prints the latest update information");
        MundoAddon.registerSubCommandDescription("update info (latest|beta|<version>)", "Prints information about the specified version");
        MundoAddon.registerSubCommandDescription("update [latest]", "Downloads the latest " + MundoAddon.name() + " version to be installed on server restart");
        MundoAddon.registerSubCommandDescription("update beta", "Downloads the latest beta " + MundoAddon.name() + " version to be installed on server restart");
        MundoAddon.registerSubCommandDescription("update <version>", "Downloads the given " + MundoAddon.name() + " version to be installed on server restart");
        MundoAddon.registerSubCommandDescription("update cancel", "Cancels the future installation of a downloaded version of " + MundoAddon.name());
    }

    public static void onUpdateCommand(CommandSender sender, String[] args) {
        if (args.length > 1 && args[1].equalsIgnoreCase("info")) {
            if (args.length == 2) {
                Scheduling.async(() -> {
                    try {
                        JSONObject versionInfo = Updating.fetchInfo("").get();
                        JSONObject latestBetaInfo = versionInfo.containsKey((Object)"latest_beta") ? Updating.fetchInfo("latest_beta").get() : null;
                        JSONObject latestInfo = versionInfo.containsKey((Object)"latest") ? Updating.fetchInfo("latest").get() : null;
                        Scheduling.sync(() -> {
                            if (latestInfo != null) {
                                Updating.displayVersionInfo(sender, latestInfo, true);
                            }
                            if (latestBetaInfo != null) {
                                Updating.displayVersionInfo(sender, latestBetaInfo, true);
                            }
                            if (versionInfo.containsKey((Object)"snapshot")) {
                                sender.sendMessage(MundoAddon.getPrimaryChatColor() + "Latest Snapshot " + MundoAddon.getAltChatColor() + versionInfo.get((Object)"snapshot"));
                            }
                        });
                    }
                    catch (IOException | ParseException e) {
                        Scheduling.sync(() -> Updating.lambda$null$1(sender, (Exception)e));
                    }
                });
            } else {
                String version = (args[2].equalsIgnoreCase("beta") ? "latest_beta" : args[2]).toLowerCase();
                boolean isLatest = version.startsWith("latest");
                Scheduling.async(() -> {
                    try {
                        Optional<JSONObject> versionInfo = Updating.fetchInfo(version);
                        Scheduling.sync(() -> {
                            if (versionInfo.isPresent()) {
                                Updating.displayVersionInfo(sender, (JSONObject)versionInfo.get(), isLatest);
                            } else {
                                sender.sendMessage(MundoAddon.getPrimaryChatColor() + "The version " + MundoAddon.getAltChatColor() + version + MundoAddon.getPrimaryChatColor() + " of " + MundoAddon.name() + " does not exist");
                            }
                        });
                    }
                    catch (IOException | ParseException e) {
                        Scheduling.sync(() -> Updating.lambda$null$4(sender, (Exception)e));
                    }
                });
            }
            return;
        }
        if (args.length > 1 && args[1].equalsIgnoreCase("cancel")) {
            Scheduling.async(() -> {
                File updateFolder = new File("update");
                updateFolder.delete();
            });
            return;
        }
        String version = (args.length == 1 ? "latest" : (args[1].equalsIgnoreCase("beta") ? "latest_beta" : args[1])).toLowerCase();
        boolean isLatest = version.startsWith("latest");
        Scheduling.async(() -> {
            try {
                Optional<JSONObject> versionInfo = Updating.fetchInfo(version);
                if (versionInfo.isPresent()) {
                    Updating.downloadUpdate(version);
                    Scheduling.sync(() -> {
                        Updating.displayVersionInfo(sender, (JSONObject)versionInfo.get(), isLatest);
                        sender.sendMessage(MundoAddon.getPrimaryChatColor() + "Update for version " + MundoAddon.getAltChatColor() + ((JSONObject)versionInfo.get()).get((Object)"version_string") + MundoAddon.getPrimaryChatColor() + " of " + MundoAddon.name() + " downloaded successfully.");
                        sender.sendMessage(MundoAddon.getPrimaryChatColor() + "Restart your server to install the update.");
                    });
                } else {
                    Scheduling.sync(() -> sender.sendMessage(MundoAddon.getPrimaryChatColor() + "The version " + MundoAddon.getAltChatColor() + version + MundoAddon.getPrimaryChatColor() + " of " + MundoAddon.name() + " does not exist"));
                }
            }
            catch (IOException | ParseException e) {
                Scheduling.sync(() -> Updating.lambda$null$9(sender, (Exception)e));
            }
        });
    }

    private static void displayVersionInfo(CommandSender sender, JSONObject versionInfo, boolean isLatest) {
        String stage = (String)versionInfo.get((Object)"stage");
        stage = Character.toUpperCase(stage.charAt(0)) + stage.substring(1);
        sender.sendMessage(MundoAddon.getPrimaryChatColor() + MundoAddon.name() + (isLatest ? " Latest " : " ") + stage + " Version " + MundoAddon.getAltChatColor() + versionInfo.get((Object)"version_string"));
        sender.sendMessage(MundoAddon.getPrimaryChatColor() + "Available " + MundoAddon.getAltChatColor() + ((Boolean)versionInfo.get((Object)"available") != false ? "Yes" : "No"));
        sender.sendMessage(MundoAddon.getPrimaryChatColor() + "Release Time " + MundoAddon.getAltChatColor() + new Timestamp(((Number)versionInfo.get((Object)"release_time")).longValue()));
        if (versionInfo.get((Object)"summary") != null) {
            sender.sendMessage(MundoAddon.getPrimaryChatColor() + "Summary " + MundoAddon.getAltChatColor() + versionInfo.get((Object)"summary"));
        }
    }

    private static Optional<JSONObject> fetchInfo(String version) throws IOException, ParseException, ClassCastException {
        URL infoURL = new URL("http://tlatoani.us/" + MundoAddon.name().toLowerCase() + "/version_info/" + version);
        HTTPClient httpClient = new HTTPClient(infoURL).method("GET").timeout(10000);
        if (httpClient.statusCode() == 404) {
            return Optional.empty();
        }
        return Optional.of((JSONObject)new JSONParser().parse((Reader)new InputStreamReader(httpClient.getInput())));
    }

    private static void downloadUpdate(String version) throws IOException {
        URL updateURL = new URL("http://tlatoani.us/" + MundoAddon.name().toLowerCase() + "/download/" + version);
        File updateFolder = Bukkit.getUpdateFolderFile();
        File updateFile = new File(updateFolder + "/" + MundoAddon.name() + ".jar");
        FileUtils.copyURLToFile((URL)updateURL, (File)updateFile);
    }

    private static /* synthetic */ void lambda$null$9(CommandSender sender, Exception e) {
        sender.sendMessage(MundoAddon.getPrimaryChatColor() + "An exception occurred while downloading the update, view the stack trace in the console for more info.");
        Logging.reportException(Updating.class, e);
    }

    private static /* synthetic */ void lambda$null$4(CommandSender sender, Exception e) {
        sender.sendMessage(MundoAddon.getPrimaryChatColor() + "Failed to retrieve version info, view the stack trace in the console for more info.");
        Logging.reportException(Updating.class, e);
    }

    private static /* synthetic */ void lambda$null$1(CommandSender sender, Exception e) {
        sender.sendMessage(MundoAddon.getPrimaryChatColor() + "Failed to retrieve version info, view the stack trace in the console for more info.");
        Logging.reportException(Updating.class, e);
    }
}

