/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.thatpacketaddon.core.registration;

import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import us.tlatoani.thatpacketaddon.core.base.Logging;
import us.tlatoani.thatpacketaddon.core.base.MundoAddon;
import us.tlatoani.thatpacketaddon.core.base.Scheduling;
import us.tlatoani.thatpacketaddon.core.registration.DocumentationBuilder;
import us.tlatoani.thatpacketaddon.core.registration.DocumentationCommand;
import us.tlatoani.thatpacketaddon.core.registration.DocumentationElement;
import us.tlatoani.thatpacketaddon.core.registration.ImmutableGroupedList;

public final class Documentation {
    public static final Comparator<String> WORD_BY_WORD_COMPARATOR = (s1, s2) -> {
        String[] words1 = s1.split(" ");
        String[] words2 = s2.split(" ");
        int i = 0;
        while (true) {
            boolean pastAllWords = true;
            for (int j = 0; j < Math.min(words1.length, words2.length); ++j) {
                if (words1[j].length() > i) {
                    if (words2[j].length() > i) {
                        if (words1[j].charAt(i) == words2[j].charAt(i)) {
                            pastAllWords = false;
                            continue;
                        }
                        return words1[j].charAt(i) - words2[j].charAt(i);
                    }
                    return 1;
                }
                if (words2[j].length() <= i) continue;
                return -1;
            }
            if (pastAllWords) break;
            ++i;
        }
        return words2.length - words1.length;
    };
    public static final Comparator<DocumentationElement> DOCUMENTATION_ELEMENT_COMPARATOR = Comparator.comparing(docElem -> docElem.name.toLowerCase(), WORD_BY_WORD_COMPARATOR);
    private static List<DocumentationBuilder> builders = new LinkedList<DocumentationBuilder>();
    private static List<String> categories;
    private static ImmutableGroupedList<DocumentationElement, String> allElements;
    private static ImmutableGroupedList<DocumentationElement.Effect, String> effects;
    private static ImmutableGroupedList<DocumentationElement.Condition, String> conditions;
    private static ImmutableGroupedList<DocumentationElement.Expression, String> expressions;
    private static ImmutableGroupedList<DocumentationElement.Event, String> events;
    private static ImmutableGroupedList<DocumentationElement.Type, String> types;
    private static ImmutableGroupedList<DocumentationElement.Scope, String> scopes;

    static void addBuilder(DocumentationBuilder builder) {
        builders.add(builder);
    }

    public static void load() {
        MundoAddon.registerSubCommand(DocumentationCommand::accessDocumentation, "doc", "docs");
        MundoAddon.registerSubCommandDescription("doc[s]", "Accesses " + MundoAddon.name() + "'s documentation");
        Scheduling.sync(Documentation::buildDocumentation);
    }

    private static void buildDocumentation() {
        ImmutableGroupedList.OrderedBuilder allElementsBuilder = new ImmutableGroupedList.OrderedBuilder(DOCUMENTATION_ELEMENT_COMPARATOR, Comparator.naturalOrder());
        ImmutableGroupedList.OrderedBuilder effectsBuilder = new ImmutableGroupedList.OrderedBuilder(DOCUMENTATION_ELEMENT_COMPARATOR, Comparator.naturalOrder());
        ImmutableGroupedList.OrderedBuilder expressionsBuilder = new ImmutableGroupedList.OrderedBuilder(DOCUMENTATION_ELEMENT_COMPARATOR, Comparator.naturalOrder());
        ImmutableGroupedList.OrderedBuilder conditionsBuilder = new ImmutableGroupedList.OrderedBuilder(DOCUMENTATION_ELEMENT_COMPARATOR, Comparator.naturalOrder());
        ImmutableGroupedList.OrderedBuilder eventsBuilder = new ImmutableGroupedList.OrderedBuilder(DOCUMENTATION_ELEMENT_COMPARATOR, Comparator.naturalOrder());
        ImmutableGroupedList.OrderedBuilder typesBuilder = new ImmutableGroupedList.OrderedBuilder(DOCUMENTATION_ELEMENT_COMPARATOR, Comparator.naturalOrder());
        ImmutableGroupedList.OrderedBuilder scopesBuilder = new ImmutableGroupedList.OrderedBuilder(DOCUMENTATION_ELEMENT_COMPARATOR, Comparator.naturalOrder());
        for (DocumentationBuilder builder : builders) {
            Object docElem = builder.build();
            allElementsBuilder.add(((DocumentationElement)docElem).category, (DocumentationElement)docElem);
            if (docElem instanceof DocumentationElement.Effect) {
                effectsBuilder.add(((DocumentationElement)docElem).category, (DocumentationElement.Effect)docElem);
                continue;
            }
            if (docElem instanceof DocumentationElement.Condition) {
                conditionsBuilder.add(((DocumentationElement)docElem).category, (DocumentationElement.Condition)docElem);
                continue;
            }
            if (docElem instanceof DocumentationElement.Expression) {
                expressionsBuilder.add(((DocumentationElement)docElem).category, (DocumentationElement.Expression)docElem);
                continue;
            }
            if (docElem instanceof DocumentationElement.Event) {
                eventsBuilder.add(((DocumentationElement)docElem).category, (DocumentationElement.Event)docElem);
                continue;
            }
            if (docElem instanceof DocumentationElement.Type) {
                typesBuilder.add(((DocumentationElement)docElem).category, (DocumentationElement.Type)docElem);
                continue;
            }
            if (!(docElem instanceof DocumentationElement.Scope)) continue;
            scopesBuilder.add(((DocumentationElement)docElem).category, (DocumentationElement.Scope)docElem);
        }
        allElements = allElementsBuilder.build();
        effects = effectsBuilder.build();
        conditions = conditionsBuilder.build();
        expressions = expressionsBuilder.build();
        events = eventsBuilder.build();
        types = typesBuilder.build();
        scopes = scopesBuilder.build();
        categories = allElements.getGroupKeys();
        Logging.debug(Documentation.class, "All DocElems: " + allElements);
    }

    public static List<String> getCategories() {
        return categories;
    }

    public static ImmutableGroupedList<DocumentationElement, String> getAllElements() {
        return allElements;
    }

    public static ImmutableGroupedList<DocumentationElement.Effect, String> getEffects() {
        return effects;
    }

    public static ImmutableGroupedList<DocumentationElement.Condition, String> getConditions() {
        return conditions;
    }

    public static ImmutableGroupedList<DocumentationElement.Expression, String> getExpressions() {
        return expressions;
    }

    public static ImmutableGroupedList<DocumentationElement.Event, String> getEvents() {
        return events;
    }

    public static ImmutableGroupedList<DocumentationElement.Type, String> getTypes() {
        return types;
    }

    public static ImmutableGroupedList<DocumentationElement.Scope, String> getScopes() {
        return scopes;
    }
}

