/*
 * Decompiled with CFR 0.152.
 */
package fr.nashoba24.teamskript;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.github.theholywaffle.teamspeak3.TS3Api;
import com.github.theholywaffle.teamspeak3.TS3Config;
import com.github.theholywaffle.teamspeak3.TS3Query;
import com.github.theholywaffle.teamspeak3.api.event.ChannelCreateEvent;
import com.github.theholywaffle.teamspeak3.api.event.ChannelDeletedEvent;
import com.github.theholywaffle.teamspeak3.api.event.ChannelDescriptionEditedEvent;
import com.github.theholywaffle.teamspeak3.api.event.ChannelEditedEvent;
import com.github.theholywaffle.teamspeak3.api.event.ChannelMovedEvent;
import com.github.theholywaffle.teamspeak3.api.event.ChannelPasswordChangedEvent;
import com.github.theholywaffle.teamspeak3.api.event.ClientJoinEvent;
import com.github.theholywaffle.teamspeak3.api.event.ClientLeaveEvent;
import com.github.theholywaffle.teamspeak3.api.event.ClientMovedEvent;
import com.github.theholywaffle.teamspeak3.api.event.PrivilegeKeyUsedEvent;
import com.github.theholywaffle.teamspeak3.api.event.ServerEditedEvent;
import com.github.theholywaffle.teamspeak3.api.event.TS3Listener;
import com.github.theholywaffle.teamspeak3.api.event.TextMessageEvent;
import com.github.theholywaffle.teamspeak3.api.exception.TS3ConnectionFailedException;
import fr.nashoba24.teamskript.TeamSkript;
import fr.nashoba24.teamskript.TsClientJoinEvent;
import fr.nashoba24.teamskript.TsClientLeaveEvent;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.bukkit.event.Event;

public class EffTSConnect
extends Effect {
    private Expression<String> host;
    private Expression<String> user;
    private Expression<String> login;
    private Expression<String> password;
    private Expression<Integer> port;
    private boolean debug = false;

    public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean paramKleenean, SkriptParser.ParseResult paramParseResult) {
        this.host = expr[0];
        this.user = expr[1];
        this.login = expr[2];
        this.password = expr[3];
        if (expr.length == 5) {
            this.port = expr[4];
        }
        if (matchedPattern == 1) {
            this.debug = true;
        }
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "ts3 connect";
    }

    protected void execute(Event e) {
        try {
            TS3Query query;
            TS3Config config = new TS3Config();
            config.setHost((String)this.host.getSingle(e));
            if (this.debug) {
                config.setDebugLevel(Level.ALL);
            } else {
                config.setDebugLevel(Level.OFF);
            }
            if ((Integer)this.port.getSingle(e) == 1) {
                config.setQueryPort(10011);
            } else {
                config.setQueryPort((Integer)this.port.getSingle(e));
            }
            TeamSkript.ts3query = query = new TS3Query(config).connect();
            final TS3Api api = query.getApi();
            api.login((String)this.login.getSingle(e), (String)this.password.getSingle(e));
            api.selectVirtualServerById(1);
            api.setNickname((String)this.user.getSingle(e));
            api.registerAllEvents();
            api.addTS3Listeners(new TS3Listener(){

                @Override
                public void onTextMessage(TextMessageEvent e) {
                }

                @Override
                public void onServerEdit(ServerEditedEvent e) {
                }

                @Override
                public void onClientMoved(ClientMovedEvent e) {
                }

                @Override
                public void onClientLeave(ClientLeaveEvent e) {
                    TeamSkript.getInstance().getServer().getPluginManager().callEvent((Event)new TsClientLeaveEvent(e.getInvokerName()));
                }

                @Override
                public void onClientJoin(ClientJoinEvent e) {
                    TeamSkript.getInstance().getServer().getPluginManager().callEvent((Event)new TsClientJoinEvent(api.getClientByNameExact(e.getInvokerName(), false)));
                }

                @Override
                public void onChannelEdit(ChannelEditedEvent e) {
                }

                @Override
                public void onChannelDescriptionChanged(ChannelDescriptionEditedEvent e) {
                }

                @Override
                public void onChannelCreate(ChannelCreateEvent e) {
                }

                @Override
                public void onChannelDeleted(ChannelDeletedEvent e) {
                }

                @Override
                public void onChannelMoved(ChannelMovedEvent e) {
                }

                @Override
                public void onChannelPasswordChanged(ChannelPasswordChangedEvent e) {
                }

                @Override
                public void onPrivilegeKeyUsed(PrivilegeKeyUsedEvent e) {
                }
            });
            TeamSkript.ts3api = api;
        }
        catch (TS3ConnectionFailedException e1) {
            TeamSkript.getInstance().getLogger().warning("Tried to connect to " + this.host + " but don't succeed");
            TeamSkript.ts3query = null;
            TeamSkript.ts3api = null;
            return;
        }
    }
}

