/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.tablisknu.tablist_general;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.bukkit.event.Event;
import us.tlatoani.tablisknu.core.util.MathUtil;
import us.tlatoani.tablisknu.tablist.Tablist;
import us.tlatoani.tablisknu.tablist.TablistProvider;

public class ExprHeightOfHeaderFooter
extends SimpleExpression<Number> {
    TablistProvider tablistProvider;
    boolean header;

    protected Number[] get(Event event) {
        return (Number[])this.tablistProvider.view(event).map(this.header ? Tablist::getHeader : Tablist::getFooter).map(List::size).toArray(Number[]::new);
    }

    public boolean isSingle() {
        return this.tablistProvider.isSingle();
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public String toString(Event event, boolean b) {
        return this.tablistProvider.toString("height of tablist " + (this.header ? "header" : "footer") + " [of %]");
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.tablistProvider = TablistProvider.of(expressions, 0);
        this.header = parseResult.mark == 0;
        return true;
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        if (delta[0] == null) {
            return;
        }
        int value = ((Number)delta[0]).intValue();
        for (Tablist tablist : this.tablistProvider.get(event)) {
            ImmutableList<String> original = this.header ? tablist.getHeader() : tablist.getFooter();
            int newHeight = MathUtil.change(mode, original.size(), value);
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < newHeight; ++i) {
                builder.add((Object)(i < original.size() ? (String)original.get(i) : ""));
            }
            if (this.header) {
                tablist.setHeader((ImmutableList<String>)builder.build());
                continue;
            }
            tablist.setFooter((ImmutableList<String>)builder.build());
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }
}

