/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.tablisknu.tablist;

import com.google.common.collect.Iterators;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.bukkit.entity.Player;
import us.tlatoani.tablisknu.tablist.Tablist;
import us.tlatoani.tablisknu.tablist.TablistManager;

public class TablistGroup
implements Iterable<Tablist> {
    private Tablist dummy = new Tablist();
    private final Map<Player, Tablist> tablists = new HashMap<Player, Tablist>();

    public Tablist getDummy() {
        return this.dummy;
    }

    @Override
    public Iterator<Tablist> iterator() {
        return Iterators.concat(Collections.singleton(this.dummy).iterator(), this.tablists.values().iterator());
    }

    public Set<Player> getPlayers() {
        return Collections.unmodifiableSet(this.tablists.keySet());
    }

    public void add(Player player) {
        if (player == null || !player.isOnline()) {
            throw new IllegalArgumentException("The player parameter in add(Player player) must be non-null and online, player: " + player);
        }
        this.tablists.computeIfAbsent(player, __ -> {
            Tablist tablist = TablistManager.getTablistOfPlayer(player);
            this.dummy.applyChanges(tablist);
            return tablist;
        });
    }

    public boolean remove(Player player) {
        if (player == null || !player.isOnline()) {
            throw new IllegalArgumentException("The player parameter in remove(Player player) must be non-null and online, player: " + player);
        }
        return this.tablists.remove(player) != null;
    }

    public void clear() {
        this.tablists.clear();
    }

    public void reset() {
        this.clear();
        this.dummy = new Tablist();
    }
}

