/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.tablisknu.skin;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.registrations.Classes;
import ch.njol.yggdrasil.Fields;
import java.io.StreamCorruptedException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import us.tlatoani.tablisknu.core.base.Logging;
import us.tlatoani.tablisknu.core.registration.DocumentationBuilder;
import us.tlatoani.tablisknu.core.registration.MundoClassInfo;
import us.tlatoani.tablisknu.core.registration.Registration;
import us.tlatoani.tablisknu.skin.ExprAllFullColorSkins;
import us.tlatoani.tablisknu.skin.ExprDisplayedSkinOfPlayer;
import us.tlatoani.tablisknu.skin.ExprFullColorSkin;
import us.tlatoani.tablisknu.skin.ExprNameTagOfPlayer;
import us.tlatoani.tablisknu.skin.ExprSkinOf;
import us.tlatoani.tablisknu.skin.ExprSkinWith;
import us.tlatoani.tablisknu.skin.FullColorSkins;
import us.tlatoani.tablisknu.skin.Skin;
import us.tlatoani.tablisknu.skin.retrieval.EffRetrieveSkin;

public class SkinMundo {
    public static void load() {
        ((MundoClassInfo)((MundoClassInfo)((MundoClassInfo)((MundoClassInfo)Registration.registerType(Skin.class, "skin", new String[0]).document("Skin Texture", "1.0", new String[]{"Represents a skin, possibly of a player. Write 'steve' or 'alex' for these respective skins."})).example(new String[]{"skin with name \"eyJ0aW1lc3RhbXAiOjE0NzQyMTc3NjkwMDAsInByb2ZpbGVJZCI6ImIwZDRiMjhiYzFkNzQ4ODlhZjBlODY2MWNlZTk2YWFiIiwicHJvZmlsZU5hbWUiOiJJbnZlbnRpdmVHYW1lcyIsInNpZ25hdHVyZVJlcXVpcmVkIjp0cnVlLCJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZWE5MmI0NTY2ZjlhMjg2OTNlNGMyNGFiMTQxNzJjZDM0MjdiNzJiZGE4ZjM0ZDRhNjEwODM3YTQ3ZGEwZGUifX19\" signature \"pRQbSEnKkNmi0uW7r8H4xzoWS3E4tkWNbiwwRYgmvITr0xHWSKii69TcaYDoDBXGBwZ525Ex5z5lYe5Xg6zb7pyBPiTJj8J0QdKenQefVnm6Vi1SAR1uN131sRddgK2Gpb2z0ffsR9USDjJAPQtQwCqz0M7sHeXUJhuRxnbznpuZwGq+B34f1TqyVH8rcOSQW9zd+RY/MEUuIHxmSRZlfFIwYVtMCEmv4SbhjLNIooGp3z0CWqDhA7GlJcDFb64FlsJyxrAGnAsUwL2ocoikyIQceyj+TVyGIEuMIpdEifO6+NkCnV7v+zTmcutOfA7kHlj4d1e5ylwi3/3k4VKZhINyFRE8M8gnLgbVxNZ4mNtI3ZMWmtmBnl9dVujyo+5g+vceIj5Admq6TOE0hy7XoDVifLWyNwO/kSlXl34ZDq1MCVN9f1ryj4aN7BB8/Tb2M4sJf3YoGi0co0Hz/A4y14M5JriG21lngw/vi5Pg90GFz64ASssWDN9gwuf5xPLUHvADGo0Bue8KPZPyI0iuIi/3sZCQrMcdyVcur+facIObTQhMut71h8xFeU05yFkQUOKIQswaz2fpPb/cEypWoSCeQV8T0w0e3YKLi4RaWWvKS1MFJDHn7xMYaTk0OhALJoV5BxRD8vJeRi5jYf3DjEgt9+xB742HrbVRDlJuTp4=\""})).example(new String[]{"player's skin"})).example(new String[]{"alex"})).example(new String[]{"steve"}).parser(new Registration.SimpleParser<Skin>(){

            public Skin parse(String s, ParseContext parseContext) {
                if (s.equalsIgnoreCase("STEVE")) {
                    return Skin.STEVE;
                }
                if (s.equalsIgnoreCase("ALEX")) {
                    return Skin.ALEX;
                }
                return null;
            }
        }).serializer((Serializer)new Serializer<Skin>(){

            public Fields serialize(Skin skin) {
                Fields fields = new Fields();
                fields.putObject("value", (Object)skin.value);
                fields.putObject("signature", (Object)skin.signature);
                return fields;
            }

            public void deserialize(Skin skin, Fields fields) {
                throw new UnsupportedOperationException("Skin does not have a nullary constructor!");
            }

            public Skin deserialize(Fields fields) throws StreamCorruptedException {
                try {
                    String value = (String)fields.getObject("value");
                    String signature = (String)fields.getObject("signature");
                    Logging.debug(SkinMundo.class, "value: " + value + ", signature: " + signature);
                    return new Skin(value, signature);
                }
                catch (StreamCorruptedException | ClassCastException e) {
                    try {
                        String value = (String)fields.getObject("value");
                        Logging.debug(SkinMundo.class, "value: " + value);
                        Object parsedObject = new JSONParser().parse(value);
                        Logging.debug(SkinMundo.class, "parsedobject: " + parsedObject);
                        JSONObject jsonObject = parsedObject instanceof JSONObject ? (JSONObject)parsedObject : (JSONObject)((JSONArray)parsedObject).get(0);
                        return Skin.fromJSON(jsonObject);
                    }
                    catch (ClassCastException | ParseException e1) {
                        throw new StreamCorruptedException();
                    }
                }
            }

            public boolean mustSyncDeserialization() {
                return false;
            }

            public boolean canBeInstantiated(Class<? extends Skin> c) {
                return false;
            }

            protected boolean canBeInstantiated() {
                return false;
            }
        });
        Logging.debug(SkinMundo.class, "ClassInfo object for Skin.class: " + Classes.getExactClassInfo(Skin.class));
        Registration.registerEffect(EffRetrieveSkin.class, "retrieve [(8\u00a6slim)] skin from (0\u00a6file|1\u00a6url) %-string% [[with] timeout %-timespan%] into %object%", "retrieve skin (2\u00a6from uuid %-string%|3\u00a6of %-offlineplayer%|4\u00a6from blueprint %-blueprint%) [[with] timeout %-timespan%] into %object%").document("Retrieve Skin", "1.0", new String[]{"Retrieves a certain skin from online and places it into the specified variable (the object expression at the end). The retrieved skin is either a skin made from the specified image file, a skin from the specified URL, or the skin of either the specified offline player or the offline player with the specified uuid. If you are retrieving a skin made from an image file or from a URL, you can specify it as slim, meaning it would have the smaller arm size like the default Alex skin does, as opposed to the larger arms of the default Steve skin. Note that since this effect has to retrieve data from online APIs, it is a delayed effect and all code following the effect will also be delayed. Tablisknu uses the Mineskin API for retrieving skins based on image files and URLs."});
        ((DocumentationBuilder.Expression)((DocumentationBuilder.Expression)Registration.registerExpression(ExprFullColorSkin.class, Skin.class, ExpressionType.PROPERTY, (String[])FullColorSkins.getSkinNames().stream().map(name -> name.toLowerCase().replace('_', ' ') + " skin").toArray(String[]::new)).document("Full Color Skin", "1.0", new String[]{"An expression for a full color skin."})).example(new String[]{"set player's displayed skin to green skin"})).example(new String[]{"enable array tablist", "set icon of tab 1, 1 to blue skin"});
        Registration.registerExpression(ExprAllFullColorSkins.class, Skin.class, ExpressionType.SIMPLE, "all full color skins").document("All Full Color Skins", "1.0", new String[]{"A list expression for all the full color skins that are available using the Full Color Skin expression. Useful for giving your tabs a bit of color variety without having to specify specific colors."});
        Registration.registerExpression(ExprSkinWith.class, Skin.class, ExpressionType.PROPERTY, "skin [texture] (with|of) value %string% signature %string%").document("Skin with Value", "1.0", new String[]{"An expression for a skin with the specified value and signature."});
        ((DocumentationBuilder.Expression)Registration.registerExpression(ExprSkinOf.class, Skin.class, ExpressionType.PROPERTY, "skin [texture] of %player/itemstack/block%", "%player/itemstack/block%'s skin").document("Skin of Player or Skull", "1.0", new String[]{"An expression for the skin of the specified player (must be online), player head item, or placed player head block."})).changer(Changer.ChangeMode.SET, Skin.class, "1.0", "Only allowed for setting the skin of a player head (item or block).");
        ((DocumentationBuilder.Expression)((DocumentationBuilder.Expression)((DocumentationBuilder.Expression)((DocumentationBuilder.Expression)((DocumentationBuilder.Expression)Registration.registerExpression(ExprDisplayedSkinOfPlayer.class, Skin.class, ExpressionType.PROPERTY, "[(1\u00a6default)] displayed skin of %player% [(for %-players%|excluding %-players%)]", "%player%'s [(1\u00a6default)] displayed skin [(for %-players%|excluding %-players%)]").document("Displayed Skin of Player", "1.0", new String[]{"An expression for the skin currently being displayed as the specified player's skin. If target ('for') players are specified, the expression will return a skin for each target player specified. Excluded players are meant to be specified only when setting the expression (for example, to prevent the original specified player from seeing a change). If the expression is evaluated with excluded players specified, it will act the same as if no target or excluded players had been specified."})).changer(Changer.ChangeMode.SET, Skin.class, "1.0", "Changes the displayed skin of the specified player. The behavior of the change differs depending on what is specified in the syntax. If none of the extra syntax options are specified, the player's default nametag will be changed, and all players will see the new nametag (any specific skins assigned for the specified player will be removed). Specifying 'default' means that only the specified player's default displayed skin will be changed, meaning that only the players who do not have a specific skin assigned for the specified player will see the new nametag. Specifying target players means that the displayed skin will be changed for those target players, and will become their specific skin assigned for the specified player. Specifying excluded players means that excluded players who do not currently have a specific skin for the specified player will have the default displayed skin for that player set as the specific skin, and then after that the effect will be the same as changing the default displayed skin. ")).changer(Changer.ChangeMode.RESET, "1.0", "If target players or excluded players are specified, this will remove any specified skin of either the target players or all non-exluded players assigned for the specified player, and revert to the default skin for the specified player. If no target players are specified, this will be identical to doing 'set <expression> to <specified player>'s skin', with that behavior depending on whether 'default' is specified.")).changer(Changer.ChangeMode.DELETE, "1.0", "Same as reset.")).example(new String[]{"set player's default displayed skin to alex #All players now see the skin as alex", "set player's displayed skin to steve for {_p1} #{_p1} now sees the skin as steve", "set player's default displayed skin to {_p2}'s skin #All players except for {_p1} now see the nametag as {_p2}'s skin", "set player's displayed skin to {_p3}'s skin #All players (including {_p1}) now see the skin as {_p3}'s skin"})).example(new String[]{"set player's default displayed skin to steve #All players now see the skin as steve", "set player's displayed skin excluding {_p1} to alex #All players except for {_p1} now see the skin as alex", "reset player's default displayed skin #All players except for {_p1} now see the skin as the player's actual skin", "set player's default displayed skin to {_p3}'s skin #All players except for {_p1} now see the skin as {_p3}'s skin", "reset player's displayed skin for {_p1} #{_p1} now sees the skin as {_p3}'s skin", "set player's displayed skin to {_p4}'s skin for {_p1} #{_p1} now sees the skin as {_p4}'s skin", "reset player's displayed skin #All players (including {_p1}) now see the skin as the player's actual skin"});
        ((DocumentationBuilder.Expression)((DocumentationBuilder.Expression)((DocumentationBuilder.Expression)((DocumentationBuilder.Expression)((DocumentationBuilder.Expression)Registration.registerExpression(ExprNameTagOfPlayer.class, String.class, ExpressionType.PROPERTY, "[mundo[sk]] %player%'s [(1\u00a6default)] name[]tag [for %-players%]", "[mundo[sk]] [(1\u00a6default)] name[]tag of %player% [for %-players%]").document("Nametag of Player", "1.0", new String[]{"An expression for the nametag (the name that appears above a player's head) of the specified player. If target ('for') players are specified, the expression will return a nametag for each target player specified. "})).changer(Changer.ChangeMode.SET, String.class, "1.0", "Changes the nametag of the specified player. The behavior of the change differs depending on what is specified in the syntax. If none of the extra syntax options are specified, the player's default nametag will be changed, and all players will see the new nametag. Specifying 'default' means that only the specified player's default nametag will be changed, meaning only the players who do not have a specific nametag assigned for the specified player will see the new nametag. Specifying target players means that the nametag will be changed for those target players, and will become their specific nametag assigned for the specified player.")).changer(Changer.ChangeMode.RESET, "1.0", "If target players are specified, this will remove any specified nametag assigned for the specified player, and revert to the default nametag for the specified player. If no target players are specified, this will be identical to doing 'set <expression> to <specified player>'s name', with that behavior depending on whether 'default' is specified.")).changer(Changer.ChangeMode.DELETE, "1.0", "Same as reset.")).example(new String[]{"set player's default nametag to \"bob\" #All players now see the nametag as bob", "set player's nametag to \"potter\" for {_p1} #{_p1} now sees the nametag as potter", "set player's default nametag to \"weird\" #All players except for {_p1} now see the nametag as weird", "set player's nametag to \"nonweird\" #All players (including {_p1}) now see the nametag as nonweird"})).example(new String[]{"set player's default nametag to \"diamond\" #All players now see the nametag as diamond", "set player's nametag to \"emerald\" for {_p1} #{_p1} now sees the nametag as emerald", "reset player's default nametag #All players except for {_p1} now see the nametag as the player's actual name", "set player's default nametag to \"gold\" #All players except for {_p1} now see the nametag as gold", "reset player's nametag for {_p1} #{_p1} now sees the nametag as gold", "set player's default nametag to \"iron\" for {_p1} #{_p1} now sees the nametag as iron", "reset player's nametag #All players (including {_p1}) now see the nametag as the player's actual name"});
    }
}

