/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.tablisknu.skin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Scanner;
import us.tlatoani.tablisknu.Tablisknu;
import us.tlatoani.tablisknu.skin.Skin;

public class FullColorSkins {
    private static ImmutableMap<String, Skin> skinMap = null;
    private static ImmutableList<String> skinNames = null;
    public static final String RESOURCE_NAME = "colored_skins.txt";

    public static void load() {
        ImmutableMap.Builder skinMapBuilder = ImmutableMap.builder();
        Scanner scanner = new Scanner(Tablisknu.get().getResource(RESOURCE_NAME));
        while (scanner.hasNext()) {
            String signature;
            String value;
            String[] colorNames;
            String line = scanner.nextLine().trim();
            if (line.isEmpty() || line.startsWith("#") || (colorNames = line.toLowerCase().split(",")).length == 0) continue;
            while ((value = scanner.nextLine().trim()).startsWith("#") || value.isEmpty()) {
            }
            while ((signature = scanner.nextLine().trim()).startsWith("#") || value.isEmpty()) {
            }
            Skin skin = new Skin(value, signature);
            for (String colorName : colorNames) {
                skinMapBuilder.put((Object)colorName.trim(), (Object)skin);
            }
        }
        skinMap = skinMapBuilder.build();
        skinNames = skinMap.keySet().asList();
    }

    public static ImmutableMap<String, Skin> getSkinMap() {
        return skinMap;
    }

    public static ImmutableList<String> getSkinNames() {
        return skinNames;
    }

    public static Skin of(String name) {
        if (!skinMap.containsKey((Object)(name = name.toLowerCase()))) {
            throw new IllegalArgumentException("Invalid skin color: " + name);
        }
        return (Skin)skinMap.get((Object)name);
    }

    public static Skin skinByIndex(int ix) {
        return FullColorSkins.of(FullColorSkins.nameByIndex(ix));
    }

    public static String nameByIndex(int ix) {
        return (String)skinNames.get(ix);
    }
}

