/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.tablisknu.blueprint;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.Variable;
import ch.njol.util.Kleenean;
import java.util.Optional;
import java.util.function.Consumer;
import org.bukkit.event.Event;
import us.tlatoani.tablisknu.blueprint.Blueprint;
import us.tlatoani.tablisknu.blueprint.BlueprintLoader;
import us.tlatoani.tablisknu.blueprint.Face;
import us.tlatoani.tablisknu.blueprint.FaceBlueprint;
import us.tlatoani.tablisknu.blueprint.Part;
import us.tlatoani.tablisknu.blueprint.PartBlueprint;
import us.tlatoani.tablisknu.skin.Skin;
import us.tlatoani.tablisknu.skin.retrieval.SkinFormat;
import us.tlatoani.tablisknu.util.LocalVariablesRestorer;

public class EffCreateBlueprint
extends Effect {
    private Expression<Skin> skinExpression;
    private Expression<String> pathExpression;
    private Optional<Part> part;
    private Optional<Face> face;
    private SkinFormat format;
    private Mode mode;
    private Variable<?> variable;

    protected TriggerItem walk(Event event) {
        LocalVariablesRestorer localVariablesRestorer = new LocalVariablesRestorer(event);
        Consumer<Blueprint> callable = blueprint -> this.afterRetrieval(event, (Blueprint)blueprint, localVariablesRestorer);
        if (this.mode == Mode.SKIN) {
            Skin skin = (Skin)this.skinExpression.getSingle(event);
            if (skin == null) {
                return super.walk(event);
            }
            localVariablesRestorer.removeVariables();
            BlueprintLoader.loadOfSkin(skin, callable);
        } else {
            String path = (String)this.pathExpression.getSingle(event);
            if (path == null) {
                return super.walk(event);
            }
            localVariablesRestorer.removeVariables();
            if (this.mode == Mode.FILE) {
                BlueprintLoader.loadFromFile(path, this.format, callable);
            } else {
                BlueprintLoader.loadFromURL(path, this.format, callable);
            }
        }
        return null;
    }

    private void afterRetrieval(Event event, Blueprint blueprint, LocalVariablesRestorer localVariablesRestorer) {
        Blueprint res;
        localVariablesRestorer.restoreVariables();
        if (!this.part.isPresent()) {
            if (this.mode == Mode.SKIN && !blueprint.isFullSize()) {
                res = new Blueprint(blueprint.format);
                res.overlay(blueprint);
                PartBlueprint[] rightParts = new PartBlueprint[]{res.getPart(Part.RIGHT_ARM, false), res.getPart(Part.RIGHT_LEG, false)};
                PartBlueprint[] leftParts = new PartBlueprint[]{res.getPart(Part.LEFT_ARM, false), res.getPart(Part.LEFT_LEG, false)};
                for (int i = 0; i < 2; ++i) {
                    for (Face face : Face.values()) {
                        Face other = face == Face.RIGHT ? Face.LEFT : (face == Face.LEFT ? Face.RIGHT : face);
                        leftParts[i].getFace(face).overlay(rightParts[i].getFace(other));
                    }
                }
            } else {
                res = blueprint;
            }
        } else {
            res = this.face.map(f -> new FaceBlueprint(this.part.get(), false, (Face)((Object)f), this.format)).orElseGet(() -> new PartBlueprint(this.part.get(), false, this.format));
            res.overlay(blueprint);
        }
        this.variable.change(event, (Object[])new Blueprint[]{res}, Changer.ChangeMode.SET);
        TriggerItem.walk((TriggerItem)this.getNext(), (Event)event);
    }

    protected void execute(Event e) {
    }

    public String toString(Event e, boolean debug) {
        switch (this.mode) {
            case SKIN: {
                return "create blueprint of " + this.skinExpression + " in " + this.variable;
            }
            case FILE: 
            case URL: {
                return "create " + (this.format == SkinFormat.STEVE ? "" : "slim ") + (this.part.map(p -> (Object)p + " ").orElse("") + this.face.map(f -> (Object)f + " face ").orElse("")).toLowerCase().replace("_", " ") + "blueprint from " + (this.mode == Mode.FILE ? "file" : "url") + " " + this.pathExpression + " in " + this.variable;
            }
        }
        throw new IllegalStateException("Illegal mode = " + (Object)((Object)this.mode));
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        Mode mode = matchedPattern == 0 ? Mode.SKIN : (this.mode = (parseResult.mark & 8) == 0 ? Mode.FILE : Mode.URL);
        if (this.mode == Mode.SKIN) {
            this.skinExpression = exprs[0];
            this.part = Optional.empty();
            this.face = Optional.empty();
        } else {
            this.pathExpression = exprs[0];
            int mark = parseResult.mark;
            this.face = (mark & 7) == 0 ? Optional.empty() : Optional.of(Face.values()[(mark & 7) - 1]);
            this.part = ((mark >>= 4) & 7) == 0 ? Optional.empty() : Optional.of(Part.values()[(mark & 7) - 1]);
            this.format = SkinFormat.values()[mark >>= 3];
        }
        this.variable = (Variable)exprs[1];
        return true;
    }

    public static enum Mode {
        SKIN,
        FILE,
        URL;

    }
}

