/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.tablisknu.blueprint;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import us.tlatoani.tablisknu.blueprint.ARGBColor;
import us.tlatoani.tablisknu.blueprint.Part;
import us.tlatoani.tablisknu.blueprint.PartBlueprint;
import us.tlatoani.tablisknu.skin.retrieval.SkinFormat;

public class Blueprint {
    protected final BufferedImage bufferedImage;
    public final SkinFormat format;

    Blueprint(BufferedImage bufferedImage, SkinFormat format) {
        if (bufferedImage.getType() == 2) {
            this.bufferedImage = bufferedImage;
        } else {
            this.bufferedImage = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
            Graphics2D graphics = this.bufferedImage.createGraphics();
            graphics.drawImage(bufferedImage, null, 0, 0);
            graphics.dispose();
        }
        this.format = format;
    }

    public Blueprint(SkinFormat format) {
        this(new BufferedImage(64, 64, 2), format);
    }

    public boolean isFullSize() {
        return this.bufferedImage.getWidth() == 64 && this.bufferedImage.getHeight() == 64;
    }

    public Blueprint duplicate() {
        Blueprint res = new Blueprint(new BufferedImage(this.bufferedImage.getWidth(), this.bufferedImage.getHeight(), 2), this.format);
        res.overlay(this);
        return res;
    }

    public Blueprint getRectangle(int x1, int y1, int x2, int y2) {
        return new Blueprint(this.bufferedImage.getSubimage(x1, y1, x2 - x1 + 1, y2 - y1 + 1), this.format);
    }

    public PartBlueprint getPart(Part part, boolean isSecondLayer) {
        if (!this.isFullSize()) {
            throw new UnsupportedOperationException("This is not a full size blueprint!");
        }
        return new PartBlueprint(isSecondLayer ? this.bufferedImage.getSubimage(part.x2, part.y2, part.imageWidth(this.format), part.imageHeight()) : this.bufferedImage.getSubimage(part.x, part.y, part.imageWidth(this.format), part.imageHeight()), part, isSecondLayer, this.format);
    }

    public ARGBColor getPixelColor(int x, int y) {
        return new ARGBColor(this.bufferedImage.getRGB(x, y));
    }

    public void colorPixel(int x, int y, ARGBColor color) {
        this.bufferedImage.setRGB(x, y, color.argb);
    }

    public void colorAll(ARGBColor color) {
        Graphics2D graphics = this.bufferedImage.createGraphics();
        graphics.setComposite(AlphaComposite.Src);
        graphics.setColor(color.toAWTColor());
        graphics.fillRect(0, 0, this.bufferedImage.getWidth(), this.bufferedImage.getHeight());
        graphics.dispose();
    }

    public void replaceColor(ARGBColor before, ARGBColor after) {
        for (int x = 0; x < this.bufferedImage.getWidth(); ++x) {
            for (int y = 0; y < this.bufferedImage.getHeight(); ++y) {
                if (this.bufferedImage.getRGB(x, y) != before.argb) continue;
                this.bufferedImage.setRGB(x, y, after.argb);
            }
        }
    }

    public void overlay(Blueprint blueprint) {
        Graphics2D graphics = this.bufferedImage.createGraphics();
        graphics.drawImage(blueprint.bufferedImage, null, 0, 0);
        graphics.dispose();
    }

    public void write(OutputStream output) throws IOException {
        ImageIO.write((RenderedImage)this.bufferedImage, "png", output);
    }

    public String toString() {
        return super.toString() + "(dim = " + this.bufferedImage.getWidth() + " * " + this.bufferedImage.getHeight() + ", format = " + (Object)((Object)this.format) + ")";
    }
}

