/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.tablisknu.blueprint;

import java.awt.Color;
import java.util.Objects;

public class ARGBColor {
    public final int argb;
    public static final ARGBColor TRANSPARENT = new ARGBColor(0);

    public ARGBColor(int argb) {
        this.argb = argb;
    }

    public static ARGBColor fromRGB(int rgb) {
        return new ARGBColor(-16777216 + rgb);
    }

    public static ARGBColor fromBukkit(org.bukkit.Color color) {
        return ARGBColor.fromRGB(color.asRGB());
    }

    public String toHexString() {
        StringBuilder res = new StringBuilder(Integer.toHexString(this.argb));
        while (res.length() < 8) {
            res.insert(0, "0");
        }
        return res.toString();
    }

    public Color toAWTColor() {
        return new Color(this.argb, true);
    }

    public boolean isOpaque() {
        return (this.argb & 0xFF000000) == -16777216;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ARGBColor argbColor = (ARGBColor)o;
        return this.argb == argbColor.argb;
    }

    public int hashCode() {
        return Objects.hash(this.argb);
    }
}

