/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.tablisknu.tablist_simple;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.Optional;
import org.bukkit.event.Event;
import us.tlatoani.tablisknu.skin.Skin;
import us.tlatoani.tablisknu.tablist.SimpleTablist;
import us.tlatoani.tablisknu.tablist.Tablist;
import us.tlatoani.tablisknu.tablist.TablistProvider;

public class EffCreateSimpleTab
extends Effect {
    private Expression<String> idExpression;
    private TablistProvider tablistProvider;
    private Optional<Expression<String>> priorityExpression;
    private Optional<Expression<String>> displayNameExpression;
    private Optional<Expression<Number>> latencyBarsExpression;
    private Optional<Expression<Skin>> iconExpression;
    private Optional<Expression<Number>> scoreExpression;

    protected void execute(Event event) {
        String id = (String)this.idExpression.getSingle(event);
        if (id == null) {
            return;
        }
        String priority = this.priorityExpression.map(expression -> (String)expression.getSingle(event)).orElse(null);
        if (priority != null && priority.length() > 12) {
            priority = priority.substring(0, 12);
        }
        String displayName = this.displayNameExpression.map(expression -> (String)expression.getSingle(event)).orElse(null);
        Integer latencyBars = this.latencyBarsExpression.map(expression -> (Number)expression.getSingle(event)).map(Number::intValue).orElse(null);
        Skin icon = this.iconExpression.map(expression -> (Skin)expression.getSingle(event)).orElse(null);
        Integer score = this.scoreExpression.map(expression -> (Number)expression.getSingle(event)).map(Number::intValue).orElse(null);
        for (Tablist tablist : this.tablistProvider.get(event)) {
            if (!(tablist.getSupplementaryTablist() instanceof SimpleTablist)) continue;
            SimpleTablist simpleTablist = (SimpleTablist)tablist.getSupplementaryTablist();
            simpleTablist.createTab(id, priority, displayName, latencyBars, icon, score);
        }
    }

    public String toString(Event event, boolean b) {
        return this.tablistProvider.toString("create simple tab " + this.idExpression + " [for %] with" + this.priorityExpression.map(expr -> " priority " + this.priorityExpression).orElse("") + this.displayNameExpression.map(expr -> " display name " + expr).orElse("") + this.latencyBarsExpression.map(expr -> " latency bars " + expr).orElse("") + this.iconExpression.map(expr -> " icon " + expr).orElse("") + this.scoreExpression.map(expr -> " score " + expr).orElse(""));
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.idExpression = expressions[0];
        this.tablistProvider = TablistProvider.of(expressions, 1);
        this.priorityExpression = Optional.ofNullable(expressions[3]);
        this.displayNameExpression = Optional.ofNullable(expressions[4]);
        this.latencyBarsExpression = Optional.ofNullable(expressions[5]);
        this.iconExpression = Optional.ofNullable(expressions[6]);
        this.scoreExpression = Optional.ofNullable(expressions[7]);
        return true;
    }
}

