/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.tablisknu.tablist_player;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import us.tlatoani.tablisknu.tablist.Tablist;
import us.tlatoani.tablisknu.tablist.TablistProvider;
import us.tlatoani.tablisknu.tablist_general.TablistMundo;

public class EffShowHidePlayerTab
extends Effect {
    private boolean visible;
    private TablistProvider tablistProvider;
    private Expression<Player> objectsExpression;

    protected void execute(Event event) {
        Player[] objects = (Player[])this.objectsExpression.getArray(event);
        if (objects == null) {
            return;
        }
        for (Tablist tablist : this.tablistProvider.get(event)) {
            tablist.getPlayerTablist().ifPresent(playerTablist -> {
                for (Player object : objects) {
                    if (!object.isOnline()) continue;
                    if (this.visible) {
                        playerTablist.showPlayer(object);
                        continue;
                    }
                    playerTablist.hidePlayer(object);
                }
            });
        }
    }

    public String toString(Event event, boolean b) {
        return this.tablistProvider.toString((this.visible ? "show " : "hide ") + this.objectsExpression + "'s player tab" + (this.objectsExpression.isSingle() ? "" : "s") + " [for %]");
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.visible = parseResult.mark == 0;
        this.tablistProvider = TablistProvider.of(expressions, 1);
        this.objectsExpression = expressions[0];
        if (!this.visible) {
            TablistMundo.printTablistSyntaxWarning("Hiding players in the tablist", null);
        }
        return true;
    }
}

