/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.tablisknu.tablist_array;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.Optional;
import org.bukkit.event.Event;
import us.tlatoani.tablisknu.skin.Skin;
import us.tlatoani.tablisknu.tablist.ArrayTablist;
import us.tlatoani.tablisknu.tablist.PlayerTablist;
import us.tlatoani.tablisknu.tablist.SimpleTablist;
import us.tlatoani.tablisknu.tablist.Tablist;
import us.tlatoani.tablisknu.tablist.TablistProvider;
import us.tlatoani.tablisknu.tablist_general.TablistMundo;

public class EffEnableDisableArrayTablist
extends Effect {
    private TablistProvider tablistProvider;
    private boolean enable;
    private Optional<Expression<Number>> columns;
    private Optional<Expression<Number>> rows;
    private Optional<Expression<Skin>> iconExpression;

    protected void execute(Event event) {
        if (this.enable) {
            int columns = this.columns.map(expression -> ((Number)expression.getSingle(event)).intValue()).orElse(4);
            int rows = this.rows.map(expression -> ((Number)expression.getSingle(event)).intValue()).orElse(20);
            Skin initialIcon = this.iconExpression.map(expression -> (Skin)expression.getSingle(event)).orElse(null);
            for (Tablist tablist : this.tablistProvider.get(event)) {
                tablist.setSupplementaryTablist(playerTablist -> {
                    if (initialIcon != null) {
                        tablist.setDefaultIcon(initialIcon);
                    }
                    return new ArrayTablist((PlayerTablist)playerTablist, columns, rows);
                });
            }
        } else {
            for (Tablist tablist : this.tablistProvider.get(event)) {
                if (!(tablist.getSupplementaryTablist() instanceof ArrayTablist)) continue;
                tablist.setSupplementaryTablist(SimpleTablist::new);
                tablist.getPlayerTablist().ifPresent(PlayerTablist::showAllPlayers);
            }
        }
    }

    public String toString(Event event, boolean b) {
        return this.tablistProvider.toString((this.enable ? "enable" : "disable") + " array tablist [for %]" + (this.enable && (this.columns.isPresent() || this.rows.isPresent() || this.iconExpression.isPresent()) ? " with" + this.columns.map(expression -> " " + expression + " columns").orElse("") + this.rows.map(expression -> " " + expression + " rows").orElse("") + this.iconExpression.map(expression -> " initial icon " + expression).orElse("") : ""));
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.tablistProvider = TablistProvider.of(expressions, 0);
        boolean bl = this.enable = i == 0;
        if (this.enable) {
            this.columns = Optional.ofNullable(expressions[2]);
            this.rows = Optional.ofNullable(expressions[3]);
            this.iconExpression = Optional.ofNullable(expressions[4]);
        }
        if (this.enable && (this.columns.isPresent() || this.rows.isPresent())) {
            TablistMundo.printTablistSyntaxWarning("Using tablist dimensions other than 4 rows and 20 columns", "use the default tablist dimensions of 4 rows and 20 columns");
        }
        return true;
    }
}

