/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.tablisknu.skin.retrieval;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import us.tlatoani.tablisknu.blueprint.Blueprint;
import us.tlatoani.tablisknu.skin.ProfileManager;
import us.tlatoani.tablisknu.skin.Skin;
import us.tlatoani.tablisknu.skin.retrieval.MineSkinRetrieval;
import us.tlatoani.tablisknu.skin.retrieval.PlayerSkinRetrieval;
import us.tlatoani.tablisknu.skin.retrieval.SkinFormat;
import us.tlatoani.tablisknu.util.LocalVariablesRestorer;

public class EffRetrieveSkin
extends Effect {
    private Expression<String> stringExpr;
    private Expression<OfflinePlayer> offlinePlayerExpr;
    private Expression<Blueprint> blueprintExpr;
    private Optional<Expression<Timespan>> timeoutExpr;
    private RetrieveMode mode;
    private Variable<?> variable;
    private SkinFormat format;

    protected TriggerItem walk(Event event) {
        int timeoutMillis = this.timeoutExpr.map(expr -> (Timespan)expr.getSingle(event)).map(Timespan::getMilliSeconds).map(Number::intValue).orElse(10000);
        LocalVariablesRestorer localVariablesRestorer = new LocalVariablesRestorer(event);
        if (this.mode == RetrieveMode.FILE || this.mode == RetrieveMode.URL) {
            String path = (String)this.stringExpr.getSingle(event);
            if (path == null) {
                return this.getNext();
            }
            localVariablesRestorer.removeVariables();
            MineSkinRetrieval.retrieveFromMineSkinAPI(this.mode == RetrieveMode.FILE ? MineSkinRetrieval.Source.FILE : MineSkinRetrieval.Source.URL, path, this.format, timeoutMillis, skin -> this.afterRetrieval(event, (Skin)skin, localVariablesRestorer));
        } else if (this.mode == RetrieveMode.UUID || this.mode == RetrieveMode.OFFLINE_PLAYER) {
            OfflinePlayer offlinePlayer = this.mode == RetrieveMode.UUID ? Bukkit.getOfflinePlayer((UUID)UUID.fromString((String)this.stringExpr.getSingle(event))) : (OfflinePlayer)this.offlinePlayerExpr.getSingle(event);
            if (offlinePlayer == null) {
                return this.getNext();
            }
            if (Bukkit.getOnlineMode()) {
                Skin skin2;
                if (offlinePlayer.isOnline() && (skin2 = ProfileManager.getProfile(offlinePlayer.getPlayer()).getActualSkin()) != null && !Skin.EMPTY.equals(skin2)) {
                    this.variable.change(event, (Object[])new Skin[]{skin2}, Changer.ChangeMode.SET);
                    return this.getNext();
                }
                localVariablesRestorer.removeVariables();
                PlayerSkinRetrieval.retrieveSkinFromUUID(offlinePlayer.getUniqueId(), timeoutMillis, skin -> this.afterRetrieval(event, (Skin)skin, localVariablesRestorer));
            } else {
                localVariablesRestorer.removeVariables();
                PlayerSkinRetrieval.retrieveSkinFromName(offlinePlayer.getName(), timeoutMillis, skin -> this.afterRetrieval(event, (Skin)skin, localVariablesRestorer));
            }
        } else if (this.mode == RetrieveMode.BLUEPRINT) {
            Blueprint blueprint = (Blueprint)this.blueprintExpr.getSingle(event);
            if (blueprint == null) {
                return this.getNext();
            }
            localVariablesRestorer.removeVariables();
            MineSkinRetrieval.retrieveFromMineSkinAPIUsingBlueprint(blueprint, timeoutMillis, skin -> this.afterRetrieval(event, (Skin)skin, localVariablesRestorer));
        }
        return null;
    }

    private void afterRetrieval(Event event, Skin skin, LocalVariablesRestorer localVariablesRestorer) {
        localVariablesRestorer.restoreVariables();
        this.variable.change(event, (Object[])new Skin[]{skin}, Changer.ChangeMode.SET);
        TriggerItem.walk((TriggerItem)this.getNext(), (Event)event);
    }

    protected void execute(Event event) {
    }

    public String toString(Event event, boolean b) {
        String suffix = this.timeoutExpr.map(expr -> " with timeout " + expr).orElse("") + " into " + this.variable;
        switch (this.mode) {
            case FILE: {
                return "retrieve" + (this.format == SkinFormat.STEVE ? "" : " slim") + " skin from file " + this.stringExpr + suffix;
            }
            case URL: {
                return "retrieve" + (this.format == SkinFormat.STEVE ? "" : " slim") + " skin from url " + this.stringExpr + suffix;
            }
            case UUID: {
                return "retrieve skin from uuid " + this.stringExpr + suffix;
            }
            case OFFLINE_PLAYER: {
                return "retrieve skin of " + this.offlinePlayerExpr + suffix;
            }
        }
        throw new IllegalStateException("RetrieveMode = " + (Object)((Object)this.mode));
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.mode = RetrieveMode.values()[parseResult.mark & 7];
        this.format = SkinFormat.values()[parseResult.mark >> 3];
        this.stringExpr = expressions[0];
        if (this.mode == RetrieveMode.OFFLINE_PLAYER) {
            this.offlinePlayerExpr = expressions[1];
        } else if (this.mode == RetrieveMode.BLUEPRINT) {
            this.blueprintExpr = expressions[2];
        }
        this.timeoutExpr = Optional.ofNullable(expressions[expressions.length - 2]);
        if (!(expressions[expressions.length - 1] instanceof Variable)) {
            Skript.error((String)"The 'retrieve skin' effect can only retrieve into variables!");
            return false;
        }
        this.variable = (Variable)expressions[expressions.length - 1];
        return true;
    }

    public static enum RetrieveMode {
        FILE,
        URL,
        UUID,
        OFFLINE_PLAYER,
        BLUEPRINT;

    }
}

