/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.tablisknu.core.util;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.variables.Variables;
import java.util.TreeMap;
import java.util.function.Function;
import org.bukkit.event.Event;
import us.tlatoani.tablisknu.core.util.Utilities;

public class SkriptUtil {
    public static <T> boolean check(Expression<T> expression, Event event, Function<T, Boolean> function) {
        return expression.check(event, function::apply);
    }

    public static <T> boolean check(Expression<T> expression, Event event, Function<T, Boolean> function, boolean positive) {
        return expression.check(event, t -> positive == (Boolean)function.apply(t));
    }

    public static TreeMap<String, Object> listVariableFromArray(Object[] array) {
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        for (int i = 1; i <= array.length; ++i) {
            if (array[i] instanceof Object[]) {
                result.put(i + "::*", SkriptUtil.listVariableFromArray((Object[])array[i]));
                continue;
            }
            if (array[i] instanceof TreeMap) {
                result.put(i + "::*", array[i]);
                continue;
            }
            result.put(i + "", array[i]);
        }
        return result;
    }

    public static void setListVariable(String varname, TreeMap<String, Object> value, Event event, boolean isLocal) {
        value.forEach((s, o) -> {
            if (o instanceof TreeMap) {
                SkriptUtil.setListVariable(varname + "::" + s, (TreeMap)o, event, isLocal);
            } else {
                Variables.setVariable((String)(varname + "::" + s), (Object)o, (Event)event, (boolean)isLocal);
            }
        });
    }

    public static boolean posCurrentEvent(Class<? extends Event> event) {
        for (Class currentEvent : ScriptLoader.getCurrentEvents()) {
            if (!Utilities.classesCompatible(event, currentEvent)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAssignableFromCurrentEvent(Class<?> ... events) {
        for (Class<?> event : events) {
            for (Class eventClass : ScriptLoader.getCurrentEvents()) {
                if (!event.isAssignableFrom(eventClass)) continue;
                return true;
            }
        }
        return false;
    }
}

