/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.tablisknu.core.util;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class OptionalUtil {
    public static <T> void consume(Optional<T> optional, Runnable runnable, Consumer<T> tConsumer) {
        if (optional.isPresent()) {
            optional.ifPresent(tConsumer);
        } else {
            runnable.run();
        }
    }

    public static <T> Stream<T> stream(Optional<T> optional) {
        return optional.map(Stream::of).orElseGet(Stream::empty);
    }

    public static <S, T extends S> Optional<T> cast(S obj, Class<T> tClass) {
        if (tClass.isInstance(obj)) {
            return Optional.of(obj);
        }
        return Optional.empty();
    }

    public static <T> boolean equal(@Nullable T t, Optional<T> optional) {
        if (optional == null) {
            throw new IllegalArgumentException("The optional argument should not be null");
        }
        if (t == null) {
            return !optional.isPresent();
        }
        return optional.map(t::equals).orElse(false);
    }

    public static <T> boolean referencesEqual(@Nullable T t, Optional<T> optional) {
        if (optional == null) {
            throw new IllegalArgumentException("The optional argument should not be null");
        }
        if (t == null) {
            return !optional.isPresent();
        }
        return optional.map(val -> t == val).orElse(false);
    }
}

